/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.reader.ChronicleHistoryReader;
import net.openhft.chronicle.wire.MessageHistory;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class ChronicleHistoryReaderTest
extends QueueTestCommon {
    @Test
    public void testWithQueueHistoryRecordHistoryInitial() {
        if (OS.isWindows()) {
            this.expectException("Read-only mode is not supported on Windows");
        }
        this.checkWithQueueHistoryRecordHistoryInitial(DummyListener.class);
    }

    @Test
    public void testWithQueueHistoryRecordHistoryInitialMethodIds() {
        if (OS.isWindows()) {
            this.expectException("Read-only mode is not supported on Windows");
        }
        this.checkWithQueueHistoryRecordHistoryInitial(DummyListenerId.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWithQueueHistoryRecordHistoryInitial(Class<? extends DummyListener> dummyClass) {
        this.expectException("Overriding sourceId from existing metadata, was 0, overriding to");
        MessageHistory.set(null);
        int extraTiming = 1;
        File queuePath1 = IOTools.createTempFile((String)"testWithQueueHistory1-");
        File queuePath2 = IOTools.createTempFile((String)"testWithQueueHistory2-");
        File queuePath3 = IOTools.createTempFile((String)"testWithQueueHistory3-");
        try {
            MethodReader reader;
            DummyListenerId dummy;
            AtomicInteger numberRead;
            DummyListener writer3;
            Throwable throwable;
            SingleChronicleQueue out3;
            try (SingleChronicleQueue out2 = this.queue(queuePath1, 1);){
                DummyListener writer2 = (DummyListener)out2.acquireAppender().methodWriterBuilder(dummyClass).useMethodIds(true).get();
                writer2.say("hello");
            }
            var7_7 = null;
            try (SingleChronicleQueue in = this.queue(queuePath1, 1);){
                out3 = this.queue(queuePath2, 2);
                throwable = null;
                try {
                    writer3 = (DummyListener)out3.acquireAppender().methodWriterBuilder(dummyClass).get();
                    numberRead = new AtomicInteger();
                    dummy = msg -> {
                        numberRead.incrementAndGet();
                        MessageHistory history = MessageHistory.get();
                        Assert.assertEquals((long)1L, (long)history.sources());
                        Assert.assertEquals((long)(1 + extraTiming), (long)history.timings());
                        writer3.say(msg);
                    };
                    reader = in.createTailer().methodReader(new Object[]{dummy});
                    Assert.assertTrue((boolean)reader.readOne());
                    Assert.assertEquals((String)"check routed to correct dest", (long)1L, (long)numberRead.get());
                    Assert.assertFalse((boolean)reader.readOne());
                }
                catch (Throwable writer3) {
                    throwable = writer3;
                    throw writer3;
                }
                finally {
                    if (out3 != null) {
                        if (throwable != null) {
                            try {
                                out3.close();
                            }
                            catch (Throwable writer3) {
                                throwable.addSuppressed(writer3);
                            }
                        } else {
                            out3.close();
                        }
                    }
                }
            }
            catch (Throwable out3) {
                var7_7 = out3;
                throw out3;
            }
            in = this.queue(queuePath2, 2);
            var7_7 = null;
            try {
                out3 = this.queue(queuePath3, 3);
                throwable = null;
                try {
                    writer3 = (DummyListener)out3.acquireAppender().methodWriterBuilder(dummyClass).get();
                    numberRead = new AtomicInteger();
                    dummy = msg -> {
                        numberRead.incrementAndGet();
                        MessageHistory history = MessageHistory.get();
                        Assert.assertEquals((long)2L, (long)history.sources());
                        Assert.assertEquals((long)(3 + extraTiming), (long)history.timings());
                        writer3.say(msg);
                    };
                    reader = in.createTailer().methodReader(new Object[]{dummy});
                    Assert.assertTrue((boolean)reader.readOne());
                    Assert.assertEquals((String)"check routed to correct dest", (long)1L, (long)numberRead.get());
                    Assert.assertFalse((boolean)reader.readOne());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out3 != null) {
                        if (throwable != null) {
                            try {
                                out3.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            out3.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                var7_7 = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (var7_7 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable5) {
                            var7_7.addSuppressed(throwable5);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            ChronicleHistoryReader chronicleHistoryReader = new ChronicleHistoryReader().withBasePath(queuePath3.toPath()).withTimeUnit(TimeUnit.MICROSECONDS).withMessageSink(System.out::println);
            Map histos = chronicleHistoryReader.readChronicle();
            chronicleHistoryReader.outputData();
            Assert.assertEquals((long)5L, (long)histos.size());
            Assert.assertEquals((Object)"[1, startTo1, 2, 1to2, endToEnd]", (Object)histos.keySet().toString());
        }
        catch (Throwable throwable) {
            IOTools.deleteDirWithFiles((String[])new String[]{queuePath1.toString(), queuePath2.toString(), queuePath3.toString()});
            throw throwable;
        }
        IOTools.deleteDirWithFiles((String[])new String[]{queuePath1.toString(), queuePath2.toString(), queuePath3.toString()});
    }

    @NotNull
    private SingleChronicleQueue queue(File queuePath1, int sourceId) {
        return ChronicleQueue.singleBuilder((File)queuePath1).testBlockSize().sourceId(sourceId).build();
    }

    @FunctionalInterface
    static interface DummyListenerId
    extends DummyListener {
        @Override
        @MethodId(value=1L)
        public void say(String var1);
    }

    @FunctionalInterface
    static interface DummyListener {
        public void say(String var1);
    }
}

