/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class NotCompleteTest
extends ChronicleQueueTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterruptOrExceptionDuringSerialisation() throws InterruptedException {
        File tmpDir = DirectoryUtils.tempDir("testInterruptedDuringSerialisation");
        try {
            DirectoryUtils.deleteDir(tmpDir);
            tmpDir.mkdirs();
            List names = Collections.synchronizedList(new ArrayList());
            Person person1 = new Person(40, "Terry");
            Person interrupter = new Person(50, "Arthur");
            Person thrower = new Person(80, "Thrower");
            Person person2 = new Person(90, "Bert");
            try (SingleChronicleQueue queueReader = this.createQueue(tmpDir);
                 SingleChronicleQueue queueWriter = this.createQueue(tmpDir);){
                String dump;
                ExcerptTailer tailer = queueReader.createTailer();
                MethodReader reader = tailer.methodReader(new Object[]{person -> names.add(person.name)});
                StringBuilder queueDumpBeforeInterruptedWrite = new StringBuilder();
                this.doWrite((ChronicleQueue)queueWriter, (proxy, queue) -> {
                    proxy.accept(person1);
                    queueDumpBeforeInterruptedWrite.append(queue.dump());
                });
                String cleanedQueueDump = this.cleanQueueDump(queueDumpBeforeInterruptedWrite.toString());
                Thread writerThread = new Thread(() -> this.lambda$testInterruptOrExceptionDuringSerialisation$3((ChronicleQueue)queueWriter, interrupter));
                writerThread.start();
                writerThread.join();
                try (SingleChronicleQueue queue2 = this.createQueue(tmpDir);){
                    dump = this.cleanQueueDump(queue2.dump());
                    Assert.assertEquals((String)"queue should be unchanged by the interrupted write", (Object)cleanedQueueDump, (Object)dump);
                }
                Assert.assertTrue((boolean)reader.readOne());
                Assert.assertEquals((long)1L, (long)names.size());
                Assert.assertEquals((Object)person1.name, names.get(0));
                Assert.assertFalse((boolean)reader.readOne());
                this.doWrite((ChronicleQueue)queueWriter, (proxy, queue) -> {
                    try {
                        proxy.accept(thrower);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                });
                queue2 = this.createQueue(tmpDir);
                var17_22 = null;
                try {
                    dump = this.cleanQueueDump(queue2.dump());
                    Assert.assertEquals((String)"queue should be unchanged by the failed (exception) write", (Object)cleanedQueueDump, (Object)dump);
                }
                catch (Throwable dump2) {
                    var17_22 = dump2;
                    throw dump2;
                }
                finally {
                    if (queue2 != null) {
                        if (var17_22 != null) {
                            try {
                                queue2.close();
                            }
                            catch (Throwable dump2) {
                                var17_22.addSuppressed(dump2);
                            }
                        } else {
                            queue2.close();
                        }
                    }
                }
                Assert.assertFalse((boolean)reader.readOne());
                ExcerptAppender appender = queueWriter.acquireAppender();
                DocumentContext wd = appender.writingDocument();
                wd.rollbackOnClose();
                wd.close();
                dump = this.cleanQueueDump(queueWriter.dump());
                Assert.assertEquals((String)"queue should be unchanged by the failed (rollback) write", (Object)cleanedQueueDump, (Object)dump);
                Assert.assertFalse((boolean)reader.readOne());
                this.doWrite((ChronicleQueue)queueWriter, (proxy, queue) -> proxy.accept(person2));
                Assert.assertTrue((boolean)reader.readOne());
                Assert.assertEquals((long)2L, (long)names.size());
                Assert.assertEquals((Object)person2.name, names.get(1));
                Assert.assertFalse((boolean)reader.readOne());
            }
        }
        finally {
            try {
                IOTools.deleteDirWithFiles((File)tmpDir, (int)2);
            }
            catch (Exception e) {
                if (e instanceof AccessDeniedException && OS.isWindows()) {
                    return;
                }
                throw e;
            }
        }
    }

    @NotNull
    private SingleChronicleQueue createQueue(File tmpDir) {
        return SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).timeoutMS(500L).checkInterrupts(true).build();
    }

    private String cleanQueueDump(String from) {
        return from.replaceAll("# [0-9]+ bytes remaining$", "").replaceAll("modCount: (\\d+)", "modCount: 00");
    }

    private void doWrite(ChronicleQueue queue, BiConsumer<PersonListener, ChronicleQueue> action) {
        ExcerptAppender appender = queue.acquireAppender();
        PersonListener proxy = (PersonListener)appender.methodWriterBuilder(PersonListener.class).get();
        action.accept(proxy, queue);
    }

    @After
    public void clearInterrupt() {
        Thread.interrupted();
    }

    private /* synthetic */ void lambda$testInterruptOrExceptionDuringSerialisation$3(ChronicleQueue queueWriter, Person interrupter) {
        this.doWrite(queueWriter, (proxy, queue) -> proxy.accept(interrupter));
    }

    static class Person
    implements Marshallable {
        static final String INTERRUPT = "Arthur";
        static final String THROW = "Thrower";
        final int age;
        final String name;

        Person(int age, String name) {
            this.age = age;
            this.name = name;
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write((CharSequence)"age").int32(this.age);
            if (INTERRUPT.equals(this.name)) {
                Thread.currentThread().interrupt();
            } else {
                if (THROW.equals(this.name)) {
                    throw new NullPointerException();
                }
                wire.write((CharSequence)"name").text(this.name);
            }
        }

        public String toString() {
            return "Person{age=" + this.age + ", name='" + this.name + '\'' + '}';
        }
    }

    static interface PersonListener {
        public void accept(Person var1);
    }
}

