/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InternalAppenderWriteBytesTest
extends ChronicleQueueTestBase {
    @Before
    public void before() {
        this.expectException(exceptionKey -> OS.isMacOSX() && exceptionKey.clazz == DirectoryUtils.class, "Ignore DirectoryUtils");
    }

    @Override
    protected boolean hasExceptions(Map<ExceptionKey, Integer> exceptions) {
        exceptions.keySet().removeIf(k -> k.level == LogLevel.PERF);
        return !exceptions.isEmpty();
    }

    @Test
    public void writeJustAfterLastIndex() {
        @NotNull Bytes test = Bytes.from((String)"hello world");
        @NotNull Bytes test2 = Bytes.from((String)"hello world again");
        Bytes result = Bytes.elasticHeapByteBuffer();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).timeProvider(() -> 0L).build();){
            ExcerptAppender appender = q.acquireAppender();
            appender.writeBytes(test);
            ((InternalAppender)appender).writeBytes(1L, (BytesStore)test2);
            ExcerptTailer tailer = q.createTailer();
            tailer.readBytes(result);
            Assert.assertEquals((Object)test, (Object)result);
            result.clear();
            tailer.readBytes(result);
            Assert.assertEquals((Object)test2, (Object)result);
            result.clear();
        }
    }

    @Test
    public void dontOverwriteExisting() {
        @NotNull Bytes test = Bytes.from((String)"hello world");
        Bytes result = Bytes.elasticHeapByteBuffer();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).timeProvider(() -> 0L).build();){
            ExcerptAppender appender = q.acquireAppender();
            appender.writeBytes(test);
            this.expectException("Trying to overwrite index 0 which is before the end of the queue");
            ((InternalAppender)appender).writeBytes(0L, (BytesStore)Bytes.from((String)"HELLO WORLD"));
            ExcerptTailer tailer = q.createTailer();
            tailer.readBytes(result);
            Assert.assertEquals((Object)test, (Object)result);
            Assert.assertEquals((long)1L, (long)tailer.index());
        }
    }

    @Test
    public void dontOverwriteExistingDifferentQueueInstance() {
        long index;
        ExcerptAppender appender;
        this.expectException("Trying to overwrite index 0 which is before the end of the queue");
        this.expectException("Trying to overwrite index 1 which is before the end of the queue");
        @NotNull Bytes test = Bytes.from((String)"hello world");
        @NotNull Bytes test2 = Bytes.from((String)"hello world2");
        Bytes result = Bytes.elasticHeapByteBuffer();
        File tmpDir = this.getTmpDir();
        String expected = "--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: !int 86400000, format: yyyyMMdd'T4', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n# position: 176, header: 0\n--- !!data #binary\nlisting.highestCycle: 0\n# position: 216, header: 1\n--- !!data #binary\nlisting.lowestCycle: 0\n# position: 256, header: 2\n--- !!data #binary\nlisting.modCount: 1\n# position: 288, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 328, header: 4\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n# position: 368, header: 5\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 416, header: 6\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n...\n# 130596 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    792,\n    3401614098433\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 196,\n    lastIndex: 4\n  },\n  dataFormat: 1\n}\n# position: 196, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 32, used: 1\n  488,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 488, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 32, used: 1\n  776,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 776, header: 0\n--- !!data\nhello world\n# position: 792, header: 1\n--- !!data\nhello world2\n...\n# 130260 bytes remaining\n";
        try (SingleChronicleQueue q = this.createQueue(tmpDir);){
            appender = q.acquireAppender();
            appender.writeBytes(test);
            appender.writeBytes(test2);
            index = appender.lastIndexAppended();
        }
        Assert.assertEquals((long)1L, (long)index);
        q = this.createQueue(tmpDir);
        var9_7 = null;
        try {
            appender = (InternalAppender)q.acquireAppender();
            appender.writeBytes(0L, (BytesStore)Bytes.from((String)"HELLO WORLD"));
            appender.writeBytes(1L, (BytesStore)Bytes.from((String)"HELLO WORLD"));
            ExcerptTailer tailer = q.createTailer();
            tailer.readBytes(result);
            Assert.assertEquals((Object)test, (Object)result);
            Assert.assertEquals((long)1L, (long)tailer.index());
        }
        catch (Throwable throwable) {
            var9_7 = throwable;
            throw throwable;
        }
        finally {
            if (q != null) {
                if (var9_7 != null) {
                    try {
                        q.close();
                    }
                    catch (Throwable throwable) {
                        var9_7.addSuppressed(throwable);
                    }
                } else {
                    q.close();
                }
            }
        }
    }

    @NotNull
    private SingleChronicleQueue createQueue(File tmpDir) {
        return SingleChronicleQueueBuilder.binary((File)tmpDir).timeProvider(() -> 0L).testBlockSize().rollCycle((RollCycle)RollCycles.TEST4_DAILY).build();
    }

    @Test(expected=IllegalStateException.class)
    public void cantAppendPastTheEnd() {
        @NotNull Bytes test = Bytes.from((String)"hello world");
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).timeProvider(() -> 0L).build();){
            ExcerptAppender appender = q.acquireAppender();
            appender.writeBytes(test);
            ((InternalAppender)appender).writeBytes(2L, (BytesStore)test);
        }
    }

    @Test
    public void test3() {
        @NotNull Bytes test = Bytes.from((String)"hello world");
        Bytes result = Bytes.elasticHeapByteBuffer();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).timeProvider(() -> 0L).build();){
            ExcerptAppender appender = q.acquireAppender();
            appender.writeBytes(test);
            ExcerptTailer tailer = q.createTailer();
            this.expectException("Trying to overwrite index 0 which is before the end of the queue");
            ((InternalAppender)appender).writeBytes(0L, (BytesStore)test);
            try (DocumentContext documentContext = tailer.readingDocument();){
                result.write((BytesStore)documentContext.wire().bytes());
            }
            Assert.assertTrue((boolean)"hello world".contentEquals((CharSequence)result));
            Assert.assertEquals((long)1L, (long)tailer.index());
            result.clear();
            ((InternalAppender)appender).writeBytes(1L, (BytesStore)test);
            var8_10 = null;
            try (DocumentContext dc = tailer.readingDocument();){
                dc.rollbackOnClose();
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
            Assert.assertEquals((long)1L, (long)tailer.index());
            ((InternalAppender)appender).writeBytes(2L, (BytesStore)test);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testJumpingAMessageThrowsAIllegalStateException() {
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir("q")).rollCycle((RollCycle)RollCycles.MINUTELY).timeProvider(() -> 0L).build();
             ExcerptAppender appender = q.acquireAppender();){
            appender.writeText((CharSequence)"hello");
            appender.writeText((CharSequence)"hello2");
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().bytes().writeLong(1L);
            }
            long l = appender.lastIndexAppended();
            RollCycle rollCycle = q.rollCycle();
            int currentCycle = rollCycle.toCycle(l);
            this.expectException("wrote an EOF at 0x812c");
            long index = rollCycle.toIndex(currentCycle + 1, 1L);
            ((InternalAppender)appender).writeBytes(index, (BytesStore)Bytes.from((String)"text"));
        }
    }

    @Test
    public void appendToPreviousCycle() {
        @NotNull Bytes test = Bytes.from((String)"hello world");
        @NotNull Bytes test1 = Bytes.from((String)"hello world again cycle1");
        @NotNull Bytes test2 = Bytes.from((String)"hello world cycle2");
        Bytes result = Bytes.elasticHeapByteBuffer();
        SetTimeProvider timeProvider = new SetTimeProvider();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).timeProvider((TimeProvider)timeProvider).rollCycle((RollCycle)RollCycles.TEST_HOURLY).build();){
            ExcerptAppender appender = q.acquireAppender();
            appender.writeBytes(test);
            long nextIndexInFirstCycle = appender.lastIndexAppended() + 1L;
            int firstCycle = q.rollCycle().toCycle(nextIndexInFirstCycle);
            timeProvider.advanceMillis(TimeUnit.SECONDS.toMillis(3900L));
            appender.writeBytes(test2);
            Assert.assertTrue((boolean)this.hasEOF(q, firstCycle));
            this.expectException("Incomplete header found at pos: 33048: c0000000, overwriting");
            ((InternalAppender)appender).writeBytes(nextIndexInFirstCycle, (BytesStore)test1);
            Assert.assertFalse((boolean)this.hasEOF(q, firstCycle));
            appender.normaliseEOFs();
            ExcerptTailer tailer = q.createTailer();
            tailer.readBytes(result);
            Assert.assertEquals((Object)test, (Object)result);
            result.clear();
            tailer.readBytes(result);
            Assert.assertEquals((Object)test1, (Object)result);
            result.clear();
            tailer.readBytes(result);
            Assert.assertEquals((Object)test2, (Object)result);
        }
    }

    private boolean hasEOF(SingleChronicleQueue q, int cycle) {
        try (SingleChronicleQueueStore store = q.storeForCycle(cycle, 0L, false, null);){
            String dump = store.dump();
            System.out.println(dump);
            boolean bl = dump.contains(" EOF") && dump.contains("--- !!not-ready-meta-data");
            return bl;
        }
    }
}

