/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class CreateAtIndexTest
extends ChronicleQueueTestBase {
    @Test
    public void testWriteBytesWithIndex() {
        InternalAppender appender;
        Bytes HELLO_WORLD = Bytes.from((String)"hello world");
        File tmp = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)tmp).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            appender = (InternalAppender)queue.acquireAppender();
            appender.writeBytes(72692321484800L, (BytesStore)HELLO_WORLD);
            appender.writeBytes(72692321484801L, (BytesStore)HELLO_WORLD);
        }
        queue = SingleChronicleQueueBuilder.single((File)tmp).testBlockSize().build();
        var4_5 = null;
        try {
            appender = (InternalAppender)queue.acquireAppender();
            String before = queue.dump();
            appender.writeBytes(72692321484800L, (BytesStore)HELLO_WORLD);
            String after = queue.dump();
            Assert.assertEquals((Object)before, (Object)after);
        }
        catch (Throwable appender2) {
            var4_5 = appender2;
            throw appender2;
        }
        finally {
            if (queue != null) {
                if (var4_5 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable appender2) {
                        var4_5.addSuppressed(appender2);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = SingleChronicleQueueBuilder.single((File)tmp).testBlockSize().build();
        var4_5 = null;
        try {
            appender = (InternalAppender)queue.acquireAppender();
            try {
                appender.writeBytes(72692321484803L, (BytesStore)HELLO_WORLD);
                Assert.fail();
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Unable to move to index 421d00000003 beyond the end of the queue"));
            }
        }
        catch (Throwable appender3) {
            var4_5 = appender3;
            throw appender3;
        }
        finally {
            if (queue != null) {
                if (var4_5 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable appender3) {
                        var4_5.addSuppressed(appender3);
                    }
                } else {
                    queue.close();
                }
            }
        }
        queue = SingleChronicleQueueBuilder.single((File)tmp).testBlockSize().build();
        var4_5 = null;
        try {
            appender = (InternalAppender)queue.acquireAppender();
            appender.writeBytes(72692321484802L, (BytesStore)HELLO_WORLD);
            appender.writeBytes(72692321484803L, (BytesStore)HELLO_WORLD);
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var4_5 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var4_5.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
        try {
            IOTools.deleteDirWithFiles((File)tmp, (int)2);
        }
        catch (IORuntimeException iORuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testWrittenAndReadIndexesAreTheSameOfTheFirstExcerpt() {
        File tmp = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)tmp).testBlockSize().build();){
            long expected;
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write().text("some-data");
                expected = dc.index();
                Assert.assertTrue((expected > 0L ? 1 : 0) != 0);
            }
            appender.lastIndexAppended();
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext dc = tailer.readingDocument();){
                dc.wire().read().text();
                long actualIndex = dc.index();
                Assert.assertTrue((actualIndex > 0L ? 1 : 0) != 0);
                Assert.assertEquals((long)expected, (long)actualIndex);
                actualIndex = tailer.index();
                Assert.assertTrue((actualIndex > 0L ? 1 : 0) != 0);
                Assert.assertEquals((long)expected, (long)actualIndex);
            }
        }
    }
}

