/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.jlbh;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.jlbh.JLBH;
import org.jetbrains.annotations.NotNull;

public class TeamCityHelper {
    public static void histo(@NotNull String name, @NotNull Histogram histo, @NotNull PrintStream printStream) {
        double[] percentages = Histogram.percentilesFor(histo.totalCount());
        TeamCityHelper.printPercentiles(name, printStream, percentages, histo.getPercentiles());
    }

    public static void teamCityStatsLastRun(@NotNull String prefix, @NotNull JLBH jlbh, int iterations, @NotNull PrintStream printStream) {
        double[] percentages = Histogram.percentilesFor(iterations);
        TeamCityHelper.printPercentiles(prefix + ".end-to-end", printStream, percentages, jlbh.percentileRuns());
        for (Map.Entry<String, List<double[]>> entry : jlbh.additionalPercentileRuns().entrySet()) {
            TeamCityHelper.printPercentiles(prefix + "." + entry.getKey(), printStream, percentages, entry.getValue());
        }
    }

    private static void printPercentiles(@NotNull String s, @NotNull PrintStream printStream, @NotNull double[] percentages, @NotNull List<double[]> valuesList) {
        double[] values = valuesList.get(valuesList.size() - 1);
        TeamCityHelper.printPercentiles(s, printStream, percentages, values);
    }

    private static void printPercentiles(@NotNull String s, @NotNull PrintStream printStream, @NotNull double[] percentages, double[] values) {
        if (percentages.length != values.length) {
            percentages = TeamCityHelper.shortenArray(percentages, values.length);
        }
        for (int i = 0; i < percentages.length; ++i) {
            printStream.println("##teamcity[buildStatisticValue key='" + s + "." + percentages[i] + "' value='" + values[i] / 1000.0 + "']");
        }
    }

    @NotNull
    private static double[] shortenArray(@NotNull double[] percentages, int newLen) {
        double[] percentages2 = new double[newLen];
        System.arraycopy(percentages, 0, percentages2, 0, percentages2.length - 1);
        percentages2[newLen - 1] = percentages[percentages.length - 1];
        return percentages2;
    }
}

