/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.StringWriter;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Mocker;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StridingAQueueTest
extends ChronicleQueueTestBase {
    @Before
    public void disableFileShrinking() {
        System.setProperty("chronicle.queue.disableFileShrinking", "true");
    }

    @Test
    public void testStriding() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.currentTimeMillis(1567498753000L);
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeProvider((TimeProvider)timeProvider).rollCycle((RollCycle)RollCycles.TEST4_SECONDLY).build();){
            SAQMessage writer = (SAQMessage)queue.acquireAppender().methodWriter(SAQMessage.class, new Class[0]);
            for (int j = 1; j <= 4; ++j) {
                for (int i = 0; i < 6 + j; ++i) {
                    writer.hi(j, i);
                }
                timeProvider.advanceMillis((long)(j * 500));
            }
        }
        queue = SingleChronicleQueueBuilder.binary((File)tmpDir).testBlockSize().timeProvider((TimeProvider)timeProvider).rollCycle((RollCycle)RollCycles.TEST4_SECONDLY).build();
        var4_4 = null;
        try {
            Assert.assertEquals((Object)this.getExpected(), (Object)queue.dump().replaceAll("(?m)^#.+$\\n", ""));
            StringWriter sw = new StringWriter();
            ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD).toEnd().striding(true);
            MethodReader reader = tailer.methodReader(new Object[]{Mocker.logging(SAQMessage.class, (String)"", (StringWriter)sw)});
            while (reader.readOne()) {
            }
            Assert.assertEquals((Object)"hi[4, 9]\nhi[4, 8]\nhi[4, 4]\nhi[4, 0]\nhi[3, 8]\nhi[3, 4]\nhi[3, 0]\nhi[2, 7]\nhi[2, 5]\nhi[2, 1]\nhi[1, 4]\nhi[1, 0]\n", (Object)sw.toString().replace("\r", ""));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var4_4 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @NotNull
    private String getExpected() {
        return "--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: !short 1000, format: yyyyMMdd-HHmmss'T4', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n--- !!data #binary\nlisting.highestCycle: 1567498756\n--- !!data #binary\nlisting.lowestCycle: 1567498753\n--- !!data #binary\nlisting.modCount: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n...\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    1112,\n    4776003633166\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 196,\n    lastIndex: 16\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 32, used: 1\n  488,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 32, used: 4\n  776,\n  872,\n  968,\n  1064,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nhi: [\n  !int 1,\n  !int 0\n]\n--- !!data #binary\nhi: [\n  !int 1,\n  !int 1\n]\n--- !!data #binary\nhi: [\n  !int 1,\n  !int 2\n]\n--- !!data #binary\nhi: [\n  !int 1,\n  !int 3\n]\n--- !!data #binary\nhi: [\n  !int 1,\n  !int 4\n]\n--- !!data #binary\nhi: [\n  !int 1,\n  !int 5\n]\n--- !!data #binary\nhi: [\n  !int 1,\n  !int 6\n]\n--- !!data #binary\nhi: [\n  !int 2,\n  !int 0\n]\n--- !!data #binary\nhi: [\n  !int 2,\n  !int 1\n]\n--- !!data #binary\nhi: [\n  !int 2,\n  !int 2\n]\n--- !!data #binary\nhi: [\n  !int 2,\n  !int 3\n]\n--- !!data #binary\nhi: [\n  !int 2,\n  !int 4\n]\n--- !!data #binary\nhi: [\n  !int 2,\n  !int 5\n]\n--- !!data #binary\nhi: [\n  !int 2,\n  !int 6\n]\n--- !!data #binary\nhi: [\n  !int 2,\n  !int 7\n]\n--- !!not-ready-meta-data #binary\n...\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    968,\n    4157528342536\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 196,\n    lastIndex: 12\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 32, used: 1\n  488,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 32, used: 3\n  776,\n  872,\n  968,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nhi: [\n  !int 3,\n  !int 0\n]\n--- !!data #binary\nhi: [\n  !int 3,\n  !int 1\n]\n--- !!data #binary\nhi: [\n  !int 3,\n  !int 2\n]\n--- !!data #binary\nhi: [\n  !int 3,\n  !int 3\n]\n--- !!data #binary\nhi: [\n  !int 3,\n  !int 4\n]\n--- !!data #binary\nhi: [\n  !int 3,\n  !int 5\n]\n--- !!data #binary\nhi: [\n  !int 3,\n  !int 6\n]\n--- !!data #binary\nhi: [\n  !int 3,\n  !int 7\n]\n--- !!data #binary\nhi: [\n  !int 3,\n  !int 8\n]\n--- !!not-ready-meta-data #binary\n...\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    992,\n    4260607557641\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 196,\n    lastIndex: 12\n  },\n  dataFormat: 1\n}\n--- !!meta-data #binary\nindex2index: [\n  # length: 32, used: 1\n  488,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n--- !!meta-data #binary\nindex: [\n  # length: 32, used: 3\n  776,\n  872,\n  968,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n--- !!data #binary\nhi: [\n  !int 4,\n  !int 0\n]\n--- !!data #binary\nhi: [\n  !int 4,\n  !int 1\n]\n--- !!data #binary\nhi: [\n  !int 4,\n  !int 2\n]\n--- !!data #binary\nhi: [\n  !int 4,\n  !int 3\n]\n--- !!data #binary\nhi: [\n  !int 4,\n  !int 4\n]\n--- !!data #binary\nhi: [\n  !int 4,\n  !int 5\n]\n--- !!data #binary\nhi: [\n  !int 4,\n  !int 6\n]\n--- !!data #binary\nhi: [\n  !int 4,\n  !int 7\n]\n--- !!data #binary\nhi: [\n  !int 4,\n  !int 8\n]\n--- !!data #binary\nhi: [\n  !int 4,\n  !int 9\n]\n...\n";
    }

    static interface SAQMessage {
        public void hi(int var1, int var2);
    }
}

