/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.algo;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public enum VanillaBytesStoreHash implements BytesStoreHash<BytesStore>
{
    INSTANCE;

    public static final int K0 = 1829709757;
    public static final int K1 = -1040990263;
    public static final int K2 = 1796809623;
    public static final int K3 = 1804686935;
    public static final int M0 = 1539836845;
    public static final int M1 = -361396777;
    public static final int M2 = 2053402137;
    public static final int M3 = -2057448229;
    private static final int HI_BYTES;

    public static long agitate(long l) {
        l ^= Long.rotateLeft(l, 26);
        l ^= Long.rotateRight(l, 17);
        return l;
    }

    @Override
    public long applyAsLong(@NotNull BytesStore store) {
        int remaining = Math.toIntExact(store.realReadRemaining());
        try {
            return this.applyAsLong(store, remaining);
        }
        catch (IllegalStateException | BufferUnderflowException e) {
            throw Jvm.rethrow(e);
        }
    }

    @Override
    public long applyAsLong(BytesStore bytes, long length) throws IllegalStateException, BufferUnderflowException {
        long start = bytes.readPosition();
        if (length <= 8L) {
            long l = bytes.readIncompleteLong(start);
            return VanillaBytesStoreHash.agitate(l * 1829709757L + (l >> 32) * -1040990263L);
        }
        long h0 = length * 1829709757L;
        long h1 = 0L;
        long h2 = 0L;
        long h3 = 0L;
        int i = 0;
        while ((long)i < length - 31L) {
            if (i > 0) {
                h0 *= 1829709757L;
                h1 *= -1040990263L;
                h2 *= 1796809623L;
                h3 *= 1804686935L;
            }
            long addrI = start + (long)i;
            long l0 = bytes.readLong(addrI);
            int l0a = bytes.readInt(addrI + (long)HI_BYTES);
            long l1 = bytes.readLong(addrI + 8L);
            int l1a = bytes.readInt(addrI + 8L + (long)HI_BYTES);
            long l2 = bytes.readLong(addrI + 16L);
            int l2a = bytes.readInt(addrI + 16L + (long)HI_BYTES);
            long l3 = bytes.readLong(addrI + 24L);
            int l3a = bytes.readInt(addrI + 24L + (long)HI_BYTES);
            h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L;
            h1 += (l1 + (long)l2a - (long)l3a) * -361396777L;
            h2 += (l2 + (long)l3a - (long)l0a) * 2053402137L;
            h3 += (l3 + (long)l0a - (long)l1a) * -2057448229L;
            i += 32;
        }
        long left = length - (long)i;
        if (left > 0L) {
            if (i > 0) {
                h0 *= 1829709757L;
                h1 *= -1040990263L;
                h2 *= 1796809623L;
                h3 *= 1804686935L;
            }
            long addrI = start + (long)i;
            long l0 = bytes.readIncompleteLong(addrI);
            int l0a = (int)(l0 >> 32);
            long l1 = bytes.readIncompleteLong(addrI + 8L);
            int l1a = (int)(l1 >> 32);
            long l2 = bytes.readIncompleteLong(addrI + 16L);
            int l2a = (int)(l2 >> 32);
            long l3 = bytes.readIncompleteLong(addrI + 24L);
            int l3a = (int)(l3 >> 32);
            h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L;
            h1 += (l1 + (long)l2a - (long)l3a) * -361396777L;
            h2 += (l2 + (long)l3a - (long)l0a) * 2053402137L;
            h3 += (l3 + (long)l0a - (long)l1a) * -2057448229L;
        }
        return VanillaBytesStoreHash.agitate(h0) ^ VanillaBytesStoreHash.agitate(h1) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    static {
        HI_BYTES = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 4 : 0;
    }
}

