/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.reader;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.reader.ChronicleReaderPlugin;
import net.openhft.chronicle.queue.reader.QueueEntryHandler;
import net.openhft.chronicle.queue.reader.Reader;
import net.openhft.chronicle.queue.util.ToolsUtil;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public final class ChronicleReader
implements Reader {
    private static final long UNSET_VALUE = Long.MIN_VALUE;
    private final List<Pattern> inclusionRegex = new ArrayList<Pattern>();
    private final List<Pattern> exclusionRegex = new ArrayList<Pattern>();
    private final Pauser pauser = Pauser.millis((int)1, (int)100);
    private Path basePath;
    private long startIndex = Long.MIN_VALUE;
    private boolean tailInputSource = false;
    private long maxHistoryRecords = Long.MIN_VALUE;
    private boolean readOnly = true;
    private ChronicleReaderPlugin customPlugin;
    private Consumer<String> messageSink;
    private Function<ExcerptTailer, DocumentContext> pollMethod = ExcerptTailer::readingDocument;
    private WireType wireType = WireType.TEXT;
    private Supplier<QueueEntryHandler> entryHandlerFactory = () -> QueueEntryHandler.messageToText(this.wireType);
    private boolean displayIndex = true;
    private Class<?> methodReaderInterface;
    private volatile boolean running = true;
    private ThreadLocal<ExcerptTailer> tlTailer;

    private static boolean checkForMatches(List<Pattern> patterns, String text, boolean shouldBePresent) {
        for (Pattern pattern : patterns) {
            if (!shouldBePresent != pattern.matcher(text).find()) continue;
            return false;
        }
        return true;
    }

    private static boolean isSet(long configValue) {
        return configValue != Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        boolean retryLastOperation;
        long highestReachedIndex = 0L;
        boolean isFirstIteration = true;
        do {
            try (ChronicleQueue queue = this.createQueue();
                 QueueEntryHandler messageConverter = this.entryHandlerFactory.get();){
                boolean queueHasBeenModified;
                ExcerptTailer tailer = queue.createTailer();
                this.tlTailer = ThreadLocal.withInitial(queue::createTailer);
                do {
                    long lastObservedTailIndex;
                    if (highestReachedIndex != 0L) {
                        tailer.moveToIndex(highestReachedIndex);
                    }
                    Bytes textConversionTarget = Bytes.elasticByteBuffer();
                    try {
                        BooleanSupplier readOne;
                        this.moveToSpecifiedPosition(queue, tailer, isFirstIteration);
                        lastObservedTailIndex = tailer.index();
                        Consumer<String> messageConsumer = text -> this.applyFiltersAndLog((String)text, tailer.index());
                        if (this.methodReaderInterface == null) {
                            readOne = () -> this.readOne(messageConverter, tailer, messageConsumer);
                        } else {
                            Bytes bytes = Bytes.elasticHeapByteBuffer((int)256);
                            Object writer = ((Wire)WireType.TEXT.apply((Object)bytes)).methodWriter(this.methodReaderInterface, new Class[0]);
                            MethodReader methodReader = tailer.methodReader(new Object[]{writer});
                            readOne = () -> {
                                boolean found = methodReader.readOne();
                                if (found) {
                                    messageConsumer.accept(bytes.toString());
                                }
                                bytes.clear();
                                return found;
                            };
                        }
                        while (!Thread.currentThread().isInterrupted()) {
                            boolean found = readOne.getAsBoolean();
                            if (!found) {
                                if (this.tailInputSource) {
                                    this.pauser.pause();
                                }
                                break;
                            }
                            this.pauser.reset();
                        }
                    }
                    finally {
                        textConversionTarget.releaseLast();
                        highestReachedIndex = tailer.index();
                        isFirstIteration = false;
                    }
                    queueHasBeenModified = this.queueHasBeenModifiedSinceLastCheck(lastObservedTailIndex, queue);
                    retryLastOperation = false;
                    if (this.running) continue;
                    return;
                } while (this.tailInputSource || queueHasBeenModified);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof DateTimeParseException) {
                    retryLastOperation = true;
                    continue;
                }
                throw e;
            }
        } while (retryLastOperation);
    }

    @Override
    public boolean readOne(QueueEntryHandler messageConverter, ExcerptTailer tailer, Consumer<String> messageConsumer) {
        try (DocumentContext dc = this.pollMethod.apply(tailer);){
            if (!dc.isPresent()) {
                boolean bl = false;
                return bl;
            }
            if (this.customPlugin == null) {
                messageConverter.accept(dc.wire(), messageConsumer);
            } else {
                this.customPlugin.onReadDocument(dc, messageConsumer);
            }
        }
        return true;
    }

    public ChronicleReader withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public ChronicleReader withMessageSink(Consumer<String> messageSink) {
        this.messageSink = messageSink;
        return this;
    }

    public Consumer<String> messageSink() {
        return this.messageSink;
    }

    @Override
    public ChronicleReader withBasePath(Path path) {
        this.basePath = path;
        return this;
    }

    @Override
    public ChronicleReader withInclusionRegex(String regex) {
        this.inclusionRegex.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public ChronicleReader withExclusionRegex(String regex) {
        this.exclusionRegex.add(Pattern.compile(regex));
        return this;
    }

    @Override
    public ChronicleReader withCustomPlugin(ChronicleReaderPlugin customPlugin) {
        this.customPlugin = customPlugin;
        return this;
    }

    @Override
    public ChronicleReader withStartIndex(long index) {
        this.startIndex = index;
        return this;
    }

    @Override
    public ChronicleReader tail() {
        this.tailInputSource = true;
        return this;
    }

    @Override
    public ChronicleReader historyRecords(long maxHistoryRecords) {
        this.maxHistoryRecords = maxHistoryRecords;
        return this;
    }

    @Override
    public ChronicleReader asMethodReader(String methodReaderInterface) {
        if (methodReaderInterface == null) {
            this.entryHandlerFactory = () -> QueueEntryHandler.dummy(this.wireType);
        } else {
            try {
                this.methodReaderInterface = Class.forName(methodReaderInterface);
            }
            catch (ClassNotFoundException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }
        return this;
    }

    @Override
    public ChronicleReader withWireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    @Override
    public ChronicleReader suppressDisplayIndex() {
        this.displayIndex = false;
        return this;
    }

    public ChronicleReader withDocumentPollMethod(Function<ExcerptTailer, DocumentContext> pollMethod) {
        this.pollMethod = pollMethod;
        return this;
    }

    private boolean queueHasBeenModifiedSinceLastCheck(long lastObservedTailIndex, ChronicleQueue queue) {
        long currentTailIndex = this.indexOfEnd(queue);
        return currentTailIndex > lastObservedTailIndex;
    }

    private void moveToSpecifiedPosition(ChronicleQueue ic, ExcerptTailer tailer, boolean isFirstIteration) {
        if (ChronicleReader.isSet(this.startIndex) && isFirstIteration) {
            if (this.startIndex < ic.firstIndex()) {
                throw new IllegalArgumentException(String.format("startIndex %d is less than first index %d", this.startIndex, ic.firstIndex()));
            }
            boolean firstTime = true;
            while (!tailer.moveToIndex(this.startIndex)) {
                if (firstTime) {
                    this.messageSink.accept("Waiting for startIndex " + Long.toHexString(this.startIndex));
                    firstTime = false;
                }
                Jvm.pause((long)100L);
            }
        }
        if (ChronicleReader.isSet(this.maxHistoryRecords) && isFirstIteration) {
            tailer.toEnd();
            this.moveToIndexNFromTheEnd(tailer, this.maxHistoryRecords);
        } else if (this.tailInputSource && isFirstIteration) {
            tailer.toEnd();
        }
    }

    private void moveToIndexNFromTheEnd(ExcerptTailer tailer, long numberOfEntriesFromEnd) {
        tailer.direction(TailerDirection.BACKWARD).toEnd();
        int i = 0;
        while ((long)i < numberOfEntriesFromEnd - 1L) {
            try (DocumentContext documentContext = tailer.readingDocument();){
                if (!documentContext.isPresent()) {
                    break;
                }
            }
            ++i;
        }
        tailer.direction(TailerDirection.FORWARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long indexOfEnd(ChronicleQueue queue) {
        ExcerptTailer excerptTailer = this.tlTailer.get();
        long index = excerptTailer.index();
        try {
            long l = excerptTailer.toEnd().index();
            return l;
        }
        finally {
            excerptTailer.moveToIndex(index);
        }
    }

    @NotNull
    private ChronicleQueue createQueue() {
        if (!Files.exists(this.basePath, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Path '%s' does not exist (absolute path '%s')", this.basePath, this.basePath.toAbsolutePath()));
        }
        return SingleChronicleQueueBuilder.binary(this.basePath.toFile()).readOnly(this.readOnly).storeFileListener(StoreFileListener.NO_OP).build();
    }

    protected void applyFiltersAndLog(String text, long index) {
        if ((this.inclusionRegex.isEmpty() || ChronicleReader.checkForMatches(this.inclusionRegex, text, true)) && (this.exclusionRegex.isEmpty() || ChronicleReader.checkForMatches(this.exclusionRegex, text, false))) {
            if (this.displayIndex) {
                this.messageSink.accept("0x" + Long.toHexString(index) + ": ");
            }
            this.messageSink.accept(text);
        }
    }

    @Override
    public void stop() {
        this.running = false;
    }

    static {
        ToolsUtil.warnIfResourceTracing();
    }
}

