/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class EofMarkerOnEmptyQueueTest
extends QueueTestCommon {
    private static final ReferenceOwner test = ReferenceOwner.temporary((String)"test");
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void shouldRecoverFromEmptyQueueOnRoll() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        Assume.assumeFalse((boolean)OS.isWindows());
        this.expectException("Couldn't acquire write lock");
        this.expectException("Forced unlock for the lock");
        AtomicLong clock = new AtomicLong(System.currentTimeMillis());
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.tmpFolder.newFolder()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider(clock::get).timeoutMS(1000L).testBlockSize().build();){
            ExcerptAppender appender = queue.acquireAppender();
            DocumentContext context = appender.writingDocument();
            long expectedEofMarkerPosition = context.wire().bytes().writePosition() - 4L;
            context.wire().write((CharSequence)"foo").int32(1);
            int startCycle = queue.cycle();
            clock.addAndGet(TimeUnit.SECONDS.toMillis(1L));
            int nextCycle = queue.cycle();
            Assert.assertNotEquals((long)nextCycle, (long)startCycle);
            ExecutorService appenderExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("Appender"));
            appenderExecutor.submit(() -> EofMarkerOnEmptyQueueTest.lambda$shouldRecoverFromEmptyQueueOnRoll$0((RollingChronicleQueue)queue)).get(Jvm.isDebug() ? 3000L : 3L, TimeUnit.SECONDS);
            appenderExecutor.shutdown();
            appenderExecutor.awaitTermination(1L, TimeUnit.SECONDS);
            try (SingleChronicleQueueStore firstCycleStore = queue.storeForCycle(startCycle, 0L, false, null);){
                long firstCycleWritePosition = firstCycleStore.writePosition();
                Assert.assertEquals((long)0L, (long)firstCycleWritePosition);
                ExcerptTailer tailer = queue.createTailer();
                int recordCount = 0;
                int lastItem = -1;
                while (true) {
                    DocumentContext readCtx = tailer.readingDocument();
                    Throwable throwable = null;
                    try {
                        if (!readCtx.isPresent()) break;
                        StringBuilder name = new StringBuilder();
                        ValueIn field = readCtx.wire().readEventName(name);
                        ++recordCount;
                        lastItem = field.int32();
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (readCtx == null) continue;
                        if (throwable != null) {
                            try {
                                readCtx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        readCtx.close();
                        continue;
                    }
                    break;
                }
                Assert.assertEquals((long)1L, (long)recordCount);
                Assert.assertEquals((long)7L, (long)lastItem);
            }
        }
    }

    private static /* synthetic */ void lambda$shouldRecoverFromEmptyQueueOnRoll$0(RollingChronicleQueue queue) {
        try (DocumentContext nextCtx = queue.acquireAppender().writingDocument();){
            nextCtx.wire().write((CharSequence)"bar").int32(7);
        }
    }
}

