/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.util.Arrays;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.IntConverter;

public class Base32IntConverter
implements IntConverter {
    public static final int MAX_LENGTH = IntConverter.maxParseLength(32);
    public static final Base32IntConverter INSTANCE = new Base32IntConverter();
    static final byte[] ENCODE = new byte[128];
    static final int BASE = 32;
    private static final String CHARS = "234567ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static final char[] DECODE = "234567ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    @Override
    public int maxParseLength() {
        return MAX_LENGTH;
    }

    @Override
    public int parse(CharSequence text) {
        this.lengthCheck(text);
        int v = 0;
        for (int i = 0; i < text.length(); ++i) {
            byte b = ENCODE[text.charAt(i)];
            if (b < 0) continue;
            v = (v << 5) + b;
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, int value) {
        int start = text.length();
        while (value != 0) {
            int v = value & 0x1F;
            value >>>= 5;
            text.append(DECODE[v]);
        }
        StringUtils.reverse(text, start);
        if (text.length() > start + this.maxParseLength()) {
            Jvm.warn().on(this.getClass(), "truncated because the value was too large");
            text.setLength(start + this.maxParseLength());
        }
    }

    static {
        assert (DECODE.length == 32);
        Arrays.fill(ENCODE, (byte)-1);
        for (int i = 0; i < DECODE.length; ++i) {
            char c = DECODE[i];
            Base32IntConverter.ENCODE[c] = (byte)i;
            Base32IntConverter.ENCODE[Character.toLowerCase((char)c)] = (byte)i;
        }
        Base32IntConverter.ENCODE[48] = ENCODE[79];
        Base32IntConverter.ENCODE[49] = ENCODE[108];
        Base32IntConverter.ENCODE[56] = ENCODE[66];
        Base32IntConverter.ENCODE[57] = ENCODE[113];
        Base32IntConverter.ENCODE[61] = 0;
    }
}

