/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;

public interface ManagedCloseable
extends Closeable {
    @Override
    default public void warnAndCloseIfNotClosed() {
        if (!this.isClosing()) {
            if (Jvm.isResourceTracing() && !AbstractCloseable.DISABLE_DISCARD_WARNING) {
                ExceptionHandler warn = Jvm.getBoolean("warnAndCloseIfNotClosed") ? Jvm.warn() : Slf4jExceptionHandler.WARN;
                warn.on(this.getClass(), "Discarded without closing " + this);
            }
            Closeable.closeQuietly((Object)this);
        }
    }

    @Override
    default public void throwExceptionIfClosed() throws IllegalStateException {
        if (this.isClosing()) {
            throw new ClosedIllegalStateException(this.isClosed() ? "Closed" : "Closing");
        }
    }

    default public StackTrace createdHere() {
        return null;
    }
}

