/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.benchmark;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.FieldGroup;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.wire.Event;
import net.openhft.chronicle.wire.HashWire;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.ServicesTimestampLongConverter;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;

public abstract class TriviallyCopyableEvent<E extends TriviallyCopyableEvent<E>>
implements Event<E>,
BytesMarshallable {
    @FieldGroup(value="header")
    transient int description = this.$description();
    @LongConversion(value=ServicesTimestampLongConverter.class)
    private long eventTime;

    protected abstract int $description();

    protected abstract int $start();

    protected abstract int $length();

    public void readMarshallable(BytesIn bytes) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        int description0 = bytes.readInt();
        if (description0 != this.$description()) {
            this.carefulCopy(bytes, description0);
        } else {
            bytes.unsafeReadObject((Object)this, this.$start(), this.$length());
        }
    }

    private void carefulCopy(BytesIn in, int description0) {
        int offset = this.$start();
        int longs0 = description0 >>> 24;
        int ints0 = description0 >>> 16 & 0xFF;
        int shorts0 = description0 >>> 8 & 0x7F;
        int bytes0 = description0 & 0xFF;
        int length = longs0 * 8 + ints0 * 4 + shorts0 * 2 + bytes0;
        if (Integer.bitCount(description0) % 2 != 0 && (long)length <= in.readRemaining()) {
            int bytes;
            int shorts;
            int ints;
            int longs = this.$description() >>> 24;
            for (ints = 0; ints < Math.max(longs, longs0); ++ints) {
                long value = 0L;
                if (ints < longs0) {
                    value = in.readLong();
                }
                if (ints >= longs) continue;
                UnsafeMemory.MEMORY.writeLong((Object)this, (long)offset, value);
                offset += 8;
            }
            ints = this.$description() >>> 16 & 0xFF;
            for (shorts = 0; shorts < Math.max(ints, ints0); ++shorts) {
                int bytes2 = 0;
                if (shorts < ints0) {
                    bytes2 = in.readInt();
                }
                if (shorts >= ints) continue;
                UnsafeMemory.MEMORY.writeInt((Object)this, (long)offset, bytes2);
                offset += 4;
            }
            shorts = this.$description() >>> 8 & 0x7F;
            for (bytes = 0; bytes < Math.max(shorts, shorts0); ++bytes) {
                short value = 0;
                if (bytes < shorts0) {
                    value = in.readShort();
                }
                if (bytes >= shorts) continue;
                UnsafeMemory.MEMORY.writeShort((Object)this, (long)offset, value);
                offset += 2;
            }
            bytes = this.$description() & 0xFF;
            for (int i = 0; i < Math.max(bytes, bytes0); ++i) {
                byte value = 0;
                if (i < bytes0) {
                    value = in.readByte();
                }
                if (i >= bytes) continue;
                UnsafeMemory.MEMORY.writeByte((Object)this, (long)offset, value);
                ++offset;
            }
        } else {
            throw new IllegalStateException("Invalid description: " + Integer.toHexString(description0) + ", length: " + length + ", remaining: " + in.readRemaining());
        }
    }

    public void writeMarshallable(BytesOut bytes) throws IllegalStateException, BufferOverflowException, BufferUnderflowException, ArithmeticException {
        bytes.writeInt(this.$description());
        bytes.unsafeWriteObject((Object)this, this.$start(), this.$length());
    }

    public static Event<?> findEvent(Object[] args) {
        if (args == null) {
            return null;
        }
        for (Object arg : args) {
            if (!(arg instanceof Event)) continue;
            return (Event)arg;
        }
        return null;
    }

    public boolean usesSelfDescribingMessage() {
        return false;
    }

    public void reset() {
        Wires.reset((Object)this);
    }

    public long eventTime() {
        return this.eventTime;
    }

    public E eventTime(long eventTime) {
        this.eventTime = eventTime;
        return this.self();
    }

    public E eventTimeNow() {
        return (E)this.eventTime(ServicesTimestampLongConverter.currentTime());
    }

    private E self() {
        return (E)this;
    }

    public boolean equals(Object o) {
        return o instanceof WriteMarshallable && (this == o || Wires.isEquals((Object)this, (Object)o));
    }

    public int hashCode() {
        return HashWire.hash32((WriteMarshallable)this);
    }

    public String toString() {
        return WireType.TEXT.asString((Object)this);
    }
}

