/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.benchmark;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.internal.BytesFieldInfo;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.queue.benchmark.Rung;
import net.openhft.chronicle.queue.benchmark.TriviallyCopyableEvent;
import net.openhft.chronicle.wire.Base85LongConverter;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ServicesTimestampLongConverter;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class BookUpdate
extends TriviallyCopyableEvent {
    public static final int MAX_NUMBER_OF_BIDS = 9;
    public static final int MAX_NUMBER_OF_ASKS = 9;
    private static final int DESCRIPTION = BytesFieldInfo.lookup(BookUpdate.class).description();
    private static final int LENGTH;
    private static final int START;
    private static final long START_OF_BIDS_RATE;
    private static final long START_OF_BIDS_QTY;
    private static final long START_OF_ASKS_RATE;
    private static final long START_OF_ASKS_QTY;
    @LongConversion(value=Base85LongConverter.class)
    public long symbol;
    @LongConversion(value=Base85LongConverter.class)
    public long exchange;
    public int bidCount;
    public double bidRate0;
    public double bidRate1;
    public double bidRate2;
    public double bidRate3;
    public double bidRate4;
    public double bidRate5;
    public double bidRate6;
    public double bidRate7;
    public double bidRate8;
    public double bidRate9;
    public double bidQty0;
    public double bidQty1;
    public double bidQty2;
    public double bidQty3;
    public double bidQty4;
    public double bidQty5;
    public double bidQty6;
    public double bidQty7;
    public double bidQty8;
    public double bidQty9;
    public int askCount;
    public double askRate0;
    public double askRate1;
    public double askRate2;
    public double askRate3;
    public double askRate4;
    public double askRate5;
    public double askRate6;
    public double askRate7;
    public double askRate8;
    public double askRate9;
    public double askQty0;
    public double askQty1;
    public double askQty2;
    public double askQty3;
    public double askQty4;
    public double askQty5;
    public double askQty6;
    public double askQty7;
    public double askQty8;
    public double askQty9;

    @Override
    public boolean usesSelfDescribingMessage() {
        return false;
    }

    public int bidCount() {
        return this.bidCount;
    }

    public int askCount() {
        return this.askCount;
    }

    @Override
    protected int $description() {
        return DESCRIPTION;
    }

    @Override
    protected int $start() {
        return START;
    }

    @Override
    protected int $length() {
        return LENGTH;
    }

    public BookUpdate bidCount(int bidCount) {
        this.bidCount = bidCount;
        return this;
    }

    public BookUpdate askCount(int askCount) {
        this.askCount = askCount;
        return this;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        this.eventTime(ServicesTimestampLongConverter.INSTANCE.parse((CharSequence)wire.read("eventTime").text()));
        this.symbol = BookUpdate.readAsLong(wire, "symbol");
        this.exchange = BookUpdate.readAsLong(wire, "exchange");
        this.bidCount = this.readRungs(wire, "bid", this::setBidRungs0_9);
        this.askCount = this.readRungs(wire, "ask", this::setAskRungs0_9);
    }

    private int readRungs(@NotNull WireIn wire, String side, Consumer<List<Rung>> setRungs) {
        ArrayList rungs = new ArrayList();
        wire.read(side + "s").sequence((Object)this, (t, v) -> {
            rungs.clear();
            while (v.hasNextSequenceItem()) {
                Rung r = new Rung();
                v.marshallable((ReadMarshallable)r);
                rungs.add(r);
            }
        });
        setRungs.accept(rungs);
        return rungs.size();
    }

    public double getBidRate(int index) {
        return this.getDoubleAtOffsetIndex(index, START_OF_BIDS_RATE);
    }

    public double getBidQty(int index) {
        return this.getDoubleAtOffsetIndex(index, START_OF_BIDS_QTY);
    }

    public double getAskRate(int index) {
        return this.getDoubleAtOffsetIndex(index, START_OF_ASKS_RATE);
    }

    public double getAskQty(int index) {
        return this.getDoubleAtOffsetIndex(index, START_OF_ASKS_QTY);
    }

    private double getDoubleAtOffsetIndex(int index, long address) {
        return UnsafeMemory.UNSAFE.getDouble(this, address + (long)(index << 3));
    }

    private BookUpdate setDoubleAtOffsetIndex(int index, double rate, long address) {
        UnsafeMemory.UNSAFE.putDouble(this, address + (long)(index << 3), rate);
        return this;
    }

    public BookUpdate setBidRate(int index, double rate) {
        return this.setDoubleAtOffsetIndex(index, rate, START_OF_BIDS_RATE);
    }

    public BookUpdate setBidQty(int index, double qty) {
        return this.setDoubleAtOffsetIndex(index, qty, START_OF_BIDS_QTY);
    }

    public BookUpdate setAskRate(int index, double rate) {
        return this.setDoubleAtOffsetIndex(index, rate, START_OF_ASKS_RATE);
    }

    public BookUpdate setAskQty(int index, double qty) {
        return this.setDoubleAtOffsetIndex(index, qty, START_OF_ASKS_QTY);
    }

    public BookUpdate symbol(CharSequence text) {
        this.symbol = Base85LongConverter.INSTANCE.parse(text);
        return this;
    }

    public BookUpdate exchange(CharSequence text) {
        this.exchange = Base85LongConverter.INSTANCE.parse(text);
        return this;
    }

    public long exchange() {
        return this.exchange;
    }

    public long symbol() {
        return this.symbol;
    }

    private void setAskRungs0_9(Iterable<Rung> rungs) {
        int i = 0;
        for (Rung rung : rungs) {
            this.setAskRate(i, rung.rate).setAskQty(i, rung.qty);
            ++i;
        }
        while (i <= 9) {
            this.setAskRate(i, Double.NaN).setAskQty(i, 0.0);
            ++i;
        }
    }

    private void setBidRungs0_9(Iterable<Rung> rungs) {
        int i = 0;
        for (Rung rung : rungs) {
            this.setDoubleAtOffsetIndex(i, rung.rate, START_OF_BIDS_RATE).setBidQty(i, rung.qty);
            ++i;
        }
        while (i <= 9) {
            this.setDoubleAtOffsetIndex(i, Double.NaN, START_OF_BIDS_RATE).setBidQty(i, 0.0);
            ++i;
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((CharSequence)"eventTime").text(ServicesTimestampLongConverter.INSTANCE.asString(this.eventTime()));
        wire.write((CharSequence)"symbol").text(Base85LongConverter.INSTANCE.asText(this.symbol));
        wire.write((CharSequence)"exchange").text(Base85LongConverter.INSTANCE.asText(this.exchange));
        wire.write((CharSequence)"bids").list(this.addBidRungs(this.bidCount), Rung.class);
        wire.write((CharSequence)"asks").list(this.addAskRungs(this.askCount), Rung.class);
    }

    private List<Rung> addBidRungs(int count) {
        ArrayList<Rung> rungs = new ArrayList<Rung>(count);
        for (int i = 0; i < count; ++i) {
            rungs.add(new Rung(this.getBidRate(i), this.getBidQty(i)));
        }
        return rungs;
    }

    private List<Rung> addAskRungs(int count) {
        ArrayList<Rung> rungs = new ArrayList<Rung>(count);
        for (int i = 0; i < count; ++i) {
            rungs.add(new Rung(this.getAskRate(i), this.getAskQty(i)));
        }
        return rungs;
    }

    private static long readAsLong(@NotNull WireIn wire, String symbol) {
        StringBuilder sb = Wires.acquireStringBuilder();
        wire.read(symbol).text(sb);
        return Base85LongConverter.INSTANCE.parse((CharSequence)sb);
    }

    @Override
    public void reset() {
        super.reset();
        this.bidCount = 0;
        this.askCount = 0;
    }

    static {
        START_OF_BIDS_RATE = Jvm.fieldOffset(BookUpdate.class, (String)"bidRate0");
        START_OF_BIDS_QTY = Jvm.fieldOffset(BookUpdate.class, (String)"bidQty0");
        START_OF_ASKS_RATE = Jvm.fieldOffset(BookUpdate.class, (String)"askRate0");
        START_OF_ASKS_QTY = Jvm.fieldOffset(BookUpdate.class, (String)"askQty0");
        int[] range = BytesUtil.triviallyCopyableRange(BookUpdate.class);
        LENGTH = range[1] - range[0];
        START = range[0];
    }
}

