/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.wire.MessageHistory;
import org.junit.After;
import org.junit.Before;

public class QueueTestCommon {
    protected ThreadDump threadDump;
    protected Map<ExceptionKey, Integer> exceptions;
    private final Map<Predicate<ExceptionKey>, String> expectedExceptions = new LinkedHashMap<Predicate<ExceptionKey>, String>();

    @Before
    public void clearMessageHistory() {
        MessageHistory.get().reset();
    }

    @Before
    public void enableReferenceTracing() {
        AbstractReferenceCounted.enableReferenceTracing();
    }

    public void assertReferencesReleased() {
        AbstractReferenceCounted.assertReferencesReleased();
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void recordExceptions() {
        this.exceptions = Jvm.recordExceptions();
    }

    public void expectException(String message) {
        this.expectException(k -> k.message.contains(message) || k.throwable != null && k.throwable.getMessage().contains(message), message);
    }

    public void expectException(Predicate<ExceptionKey> predicate, String description) {
        this.expectedExceptions.put(predicate, description);
    }

    public void checkExceptions() {
        for (String msg : "Allocation of , ms to add mapping for ,jar to the classpath, ms to pollDiskSpace for , us to linearScan by position from ,File released ".split(",")) {
            this.exceptions.keySet().removeIf(e -> e.message.contains(msg));
        }
        for (Map.Entry entry : this.expectedExceptions.entrySet()) {
            if (this.exceptions.keySet().removeIf((Predicate)entry.getKey())) continue;
            Slf4jExceptionHandler.WARN.on(this.getClass(), "No error for " + (String)entry.getValue());
        }
        this.expectedExceptions.clear();
        if (this.hasExceptions(this.exceptions)) {
            Jvm.dumpException(this.exceptions);
            Jvm.resetExceptionHandlers();
            throw new AssertionError(this.exceptions.keySet());
        }
    }

    protected boolean hasExceptions(Map<ExceptionKey, Integer> exceptions) {
        return Jvm.hasException(this.exceptions);
    }

    @After
    public void resetClock() {
        SystemTimeProvider.CLOCK = SystemTimeProvider.INSTANCE;
    }

    @After
    public void afterChecks() {
        CleaningThread.performCleanup((Thread)Thread.currentThread());
        System.gc();
        AbstractCloseable.waitForCloseablesToClose((long)100L);
        this.assertReferencesReleased();
        this.checkThreadDump();
        this.checkExceptions();
    }
}

