/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesComment;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.HeadNumberChecker;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireObjectInput;
import net.openhft.chronicle.wire.WireObjectOutput;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWire
implements Wire {
    public static final boolean DEFAULT_USE_PADDING = Jvm.getBoolean("wire.usePadding", true);
    protected static final boolean ASSERTIONS;
    private static final String INSIDE_HEADER_MESSAGE = "you cant put a header inside a header, check that you have not nested the documents. If you are using Chronicle-Queue please ensure that you have a unique instance of the Appender per thread, in other-words you can not share appenders across threads.";
    @NotNull
    protected final Bytes<?> bytes;
    protected final boolean use8bit;
    protected ClassLookup classLookup = ClassAliasPool.CLASS_ALIASES;
    protected Object parent;
    int usedCount = 0;
    private Pauser pauser;
    private TimingPauser timedParser;
    private long headerNumber = Long.MIN_VALUE;
    private boolean notCompleteIsNotPresent;
    private ObjectOutput objectOutput;
    private ObjectInput objectInput;
    private boolean insideHeader;
    private HeadNumberChecker headNumberChecker;
    private boolean usePadding = false;

    public AbstractWire(@NotNull Bytes bytes, boolean use8bit) {
        this.bytes = bytes;
        this.use8bit = use8bit;
        this.notCompleteIsNotPresent = bytes.sharedMemory();
    }

    private static long throwNotEnoughSpace(int maxlen, @NotNull Bytes<?> bytes) {
        throw new IllegalStateException("not enough space to write " + maxlen + " was " + bytes.writeRemaining() + " limit " + bytes.writeLimit() + " type " + bytes.getClass());
    }

    @NotNull
    private TimingPauser acquireTimedParser() {
        return this.timedParser != null ? this.timedParser : (this.timedParser = Pauser.timedBusy());
    }

    public boolean isInsideHeader() {
        return this.insideHeader;
    }

    @Override
    public Pauser pauser() {
        if (this.pauser == null) {
            this.pauser = this.acquireTimedParser();
        }
        return this.pauser;
    }

    @Override
    public void pauser(Pauser pauser) {
        this.pauser = pauser;
    }

    @Override
    public void clear() {
        this.bytes.clear();
        this.headerNumber(Long.MIN_VALUE);
    }

    @NotNull
    private Wire headerNumber(long position, long headerNumber) {
        assert (this.checkHeader(position, headerNumber));
        return this.headerNumber0(headerNumber);
    }

    private boolean checkHeader(long position, long headerNumber) {
        return this.headNumberChecker == null || this.headNumberChecker.checkHeaderNumber(headerNumber, position);
    }

    @Override
    @NotNull
    public Wire headerNumber(long headerNumber) {
        return this.headerNumber(this.bytes().writePosition(), headerNumber);
    }

    @NotNull
    private Wire headerNumber0(long headerNumber) {
        this.headerNumber = headerNumber;
        return this;
    }

    public void headNumberCheck(HeadNumberChecker headNumberChecker) {
        this.headNumberChecker = headNumberChecker;
    }

    @Override
    public long headerNumber() {
        return this.headerNumber;
    }

    @Override
    public void classLookup(ClassLookup classLookup) {
        this.classLookup = classLookup;
    }

    @Override
    public ClassLookup classLookup() {
        return this.classLookup;
    }

    @Override
    @NotNull
    public Bytes<?> bytes() {
        return this.bytes;
    }

    @Override
    public BytesComment<?> bytesComment() {
        return this.bytes;
    }

    @Override
    @NotNull
    public WireIn.HeaderType readDataHeader(boolean includeMetaData) {
        this.alignForRead(this.bytes);
        while (true) {
            int header;
            if (((header = this.bytes.peekVolatileInt()) & Integer.MIN_VALUE) != 0 || header == 0) {
                if (header == -1073741824) {
                    return WireIn.HeaderType.EOF;
                }
                return WireIn.HeaderType.NONE;
            }
            if ((header & 0x40000000) == 0) {
                return WireIn.HeaderType.DATA;
            }
            if (includeMetaData && Wires.isReadyMetaData(header)) {
                return WireIn.HeaderType.META_DATA;
            }
            long readPosition = this.bytes.readPosition();
            int bytesToSkip = Wires.lengthOf(header) + 4;
            readPosition += (long)bytesToSkip;
            if (this.usePadding) {
                readPosition += BytesUtil.padOffset(readPosition);
            }
            this.bytes.readPosition(readPosition);
        }
    }

    private void alignForRead(Bytes<?> bytes) {
        bytes.readPositionForHeader(this.usePadding);
    }

    @Override
    public void readAndSetLength(long position) {
        this.alignForRead(this.bytes);
        int header = this.bytes.peekVolatileInt();
        if (Wires.isReady(header)) {
            if (header == 0) {
                this.throwISE();
            }
            long start = position + 4L;
            this.bytes.readPositionRemaining(start, Wires.lengthOf(header));
            return;
        }
        this.throwISE();
    }

    private void throwISE() {
        throw new IllegalStateException();
    }

    @Override
    public void readMetaDataHeader() {
        this.alignForRead(this.bytes);
        int header = this.bytes.peekVolatileInt();
        if (Wires.isReady(header)) {
            if (header == 0) {
                throw new IllegalStateException("Meta data not initialised");
            }
            if (Wires.isReadyMetaData(header)) {
                this.setLimitPosition(header);
                return;
            }
        }
        throw new IllegalStateException("Meta data not ready " + Integer.toHexString(header));
    }

    private void setLimitPosition(int header) {
        ((Bytes)this.bytes.readLimit(this.bytes.readPosition() + (long)Wires.lengthOf(header) + 4L)).readSkip(4L);
    }

    @Override
    public void readFirstHeader() throws StreamCorruptedException {
        int len;
        if (this.bytes.realCapacity() >= 4L) {
            int header = this.bytes.readVolatileInt(0L);
            if (!Wires.isReady(header)) {
                throw new StreamCorruptedException("Not ready header is found");
            }
            len = Wires.lengthOf(header);
            if (!Wires.isReadyMetaData(header) || len > 65536) {
                throw new StreamCorruptedException("Unexpected magic number " + Integer.toHexString(header));
            }
        } else {
            throw new DecoratedBufferUnderflowException("Not enough capacity to read from");
        }
        this.bytes.readPositionRemaining(4L, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFirstHeader(long timeout, TimeUnit timeUnit) throws TimeoutException, StreamCorruptedException {
        int header;
        this.resetTimedPauser();
        try {
            boolean hasAtLeast4 = false;
            while (true) {
                if (hasAtLeast4 || this.bytes.realCapacity() >= 4L) {
                    hasAtLeast4 = true;
                    header = this.bytes.readVolatileInt(0L);
                    if (Wires.isReady(header)) {
                        break;
                    }
                }
                this.acquireTimedParser().pause(timeout, timeUnit);
            }
        }
        finally {
            this.resetTimedPauser();
        }
        int len = Wires.lengthOf(header);
        if (!Wires.isReadyMetaData(header) || len > 65536) {
            throw new StreamCorruptedException("Unexpected magic number " + Integer.toHexString(header));
        }
        this.bytes.readPositionRemaining(4L, len);
    }

    @Override
    public long enterHeader(int safeLength) {
        if ((long)safeLength > this.bytes.writeRemaining()) {
            if (this.bytes.isElastic()) {
                long l = this.bytes.writeLimit();
                Jvm.warn().on(this.getClass(), "Unexpected writeLimit of " + l + " capacity " + this.bytes.capacity());
            }
            return AbstractWire.throwNotEnoughSpace(safeLength, this.bytes);
        }
        assert (!this.insideHeader) : "you cant put a header inside a header, check that you have not nested the documents. If you are using Chronicle-Queue please ensure that you have a unique instance of the Appender per thread, in other-words you can not share appenders across threads.";
        this.insideHeader = true;
        long pos = this.bytes.writePosition();
        while (true) {
            int header;
            if (this.usePadding) {
                pos += BytesUtil.padOffset(pos);
            }
            if ((header = this.bytes.readVolatileInt(pos)) == 0) break;
            if (Wires.isNotComplete(header)) {
                if (header != -1073741824) {
                    Jvm.warn().on(this.getClass(), new Exception("Incomplete header found at pos: " + pos + ": " + Integer.toHexString(header) + ", overwriting"));
                }
                this.bytes.writeVolatileInt(pos, 0);
                break;
            }
            pos += (long)(Wires.lengthOf(header) + 4);
        }
        this.bytes.writePositionRemaining(pos + 4L, safeLength);
        return pos;
    }

    @Override
    public void updateHeader(long position, boolean metaData, int expectedHeader) throws StreamCorruptedException {
        if (position <= 0L) {
            IllegalStateException ex = new IllegalStateException("Attempt to write to position=" + position);
            Slf4jExceptionHandler.WARN.on(this.getClass(), "Attempt to update header at position=" + position, ex);
            throw ex;
        }
        if (this.bytes.writePosition() == position + 4L) {
            this.addPadding(1);
        }
        long pos = this.bytes.writePosition();
        if (this.bytes.writeRemaining() >= 4L) {
            this.bytes.writeInt(pos, 0);
        } else {
            int i = 0;
            while ((long)i < this.bytes.writeRemaining()) {
                this.bytes.writeByte(pos + (long)i, 0);
                ++i;
            }
        }
        int header = Maths.toUInt31(pos - position - 4L);
        if (metaData) {
            header |= 0x40000000;
        }
        if (header == 0) {
            throw new UnsupportedOperationException("Data messages of 0 length are not supported.");
        }
        assert (this.insideHeader);
        this.insideHeader = false;
        this.updateHeaderAssertions(position, pos, expectedHeader, header);
        this.bytes.writeLimit(this.bytes.capacity());
        if (!metaData) {
            this.incrementHeaderNumber(position);
        }
    }

    private void updateHeaderAssertions(long position, long pos, int expectedHeader, int header) throws StreamCorruptedException {
        if (ASSERTIONS) {
            this.checkNoDataAfterEnd(pos);
        }
        if (!this.bytes.compareAndSwapInt(position, expectedHeader, header)) {
            int currentHeader = this.bytes.readVolatileInt(position);
            throw new StreamCorruptedException("Data at " + position + " overwritten? Expected: " + Integer.toHexString(expectedHeader) + " was " + Integer.toHexString(currentHeader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNoDataAfterEnd(long pos) {
        int value;
        if (!this.bytes.inside(pos, 4L)) {
            return;
        }
        if (pos <= this.bytes.writeLimit() - 4L && (value = this.bytes.bytesStore().readVolatileInt(pos)) != 0) {
            String text;
            long pos0 = this.bytes.readPosition();
            try {
                this.bytes.readPosition(pos);
                text = this.bytes.toDebugString();
            }
            finally {
                this.bytes.readPosition(pos0);
            }
            throw new IllegalStateException("Data was written after the end of the message, zero out data before rewinding " + text);
        }
    }

    private void incrementHeaderNumber(long pos) {
        if (this.headerNumber != Long.MIN_VALUE) {
            this.headerNumber(pos, this.headerNumber + 1L);
        }
    }

    @Override
    public boolean writeFirstHeader() {
        boolean cas = this.bytes.compareAndSwapInt(0L, 0, Integer.MIN_VALUE);
        if (cas) {
            this.bytes.writeSkip(4L);
        }
        return cas;
    }

    @Override
    public void updateFirstHeader() {
        this.padToCacheAlign();
        long pos = this.bytes.writePosition();
        long actualLength = pos - 4L;
        if (actualLength >= 0x40000000L) {
            throw new IllegalStateException("Header too large was " + actualLength);
        }
        int header = (int)(0x40000000L | actualLength);
        if (!this.bytes.compareAndSwapInt(0L, Integer.MIN_VALUE, header)) {
            throw new IllegalStateException("Data at 0 overwritten? Expected: " + Integer.toHexString(Integer.MIN_VALUE) + " was " + Integer.toHexString(this.bytes.readVolatileInt(0L)));
        }
    }

    @Override
    public boolean writeEndOfWire(long timeout, TimeUnit timeUnit, long lastPosition) {
        long pos = Math.max(lastPosition, this.bytes.writePosition());
        this.headerNumber = Long.MIN_VALUE;
        try {
            while (true) {
                if (this.usePadding) {
                    pos += BytesUtil.padOffset(pos);
                }
                if (this.bytes.compareAndSwapInt(pos, 0, -1073741824)) {
                    this.bytes.writePosition(pos + 4L);
                    boolean bl = true;
                    return bl;
                }
                int header = this.bytes.readVolatileInt(pos);
                if (header == -1073741824) {
                    boolean bl = false;
                    return bl;
                }
                if (Wires.isNotComplete(header)) {
                    try {
                        this.acquireTimedParser().pause(timeout, timeUnit);
                    }
                    catch (TimeoutException e) {
                        boolean success = this.bytes.compareAndSwapInt(pos, header, -1073741824);
                        Jvm.warn().on(this.getClass(), "resetting header after timeout, header: " + Integer.toHexString(header) + ", pos: " + pos + ", success: " + success);
                    }
                } else {
                    this.acquireTimedParser().reset();
                    int len = Wires.lengthOf(header);
                    pos += (long)(len + 4);
                }
                Jvm.nanoPause();
            }
        }
        finally {
            this.resetTimedPauser();
        }
    }

    private void resetTimedPauser() {
        if (this.timedParser != null) {
            this.timedParser.reset();
        }
    }

    @Override
    public Object parent() {
        return this.parent;
    }

    @Override
    public void parent(Object parent) {
        this.parent = parent;
    }

    @Override
    public boolean startUse() {
        ++this.usedCount;
        return true;
    }

    @Override
    public boolean endUse() {
        --this.usedCount;
        return true;
    }

    @Override
    public boolean notCompleteIsNotPresent() {
        return this.notCompleteIsNotPresent;
    }

    @Override
    public void notCompleteIsNotPresent(boolean notCompleteIsNotPresent) {
        this.notCompleteIsNotPresent = notCompleteIsNotPresent;
    }

    @Override
    public ObjectOutput objectOutput() {
        if (this.objectOutput == null) {
            this.objectOutput = new WireObjectOutput(this);
        }
        return this.objectOutput;
    }

    @Override
    public ObjectInput objectInput() {
        if (this.objectInput == null) {
            this.objectInput = new WireObjectInput(this);
        }
        return this.objectInput;
    }

    @Override
    public long readEventNumber() {
        return Long.MIN_VALUE;
    }

    public void forceNotInsideHeader() {
        this.insideHeader = false;
    }

    @Override
    public void usePadding(boolean usePadding) {
        this.usePadding = usePadding;
    }

    @Override
    public boolean usePadding() {
        return this.usePadding;
    }

    static {
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERTIONS = assertions;
        WireInternal.addAliases();
    }
}

