/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.MetaDataField;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.queue.impl.table.TableStoreIterator;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class SingleTableStore<T extends Metadata>
extends AbstractCloseable
implements TableStore<T> {
    public static final String SUFFIX = ".cq4t";
    private static final int EXCLUSIVE_LOCK_SIZE = 1;
    private static final long EXCLUSIVE_LOCK_START = 0x7FFFFFFFFFFFFFFEL;
    private static final long timeoutMS = Long.getLong("chronicle.table.store.timeoutMS", 10000L);
    @NotNull
    private final WireType wireType;
    @NotNull
    private final T metadata;
    @NotNull
    private final MappedBytes mappedBytes;
    @NotNull
    private final MappedFile mappedFile;
    @NotNull
    private final Wire mappedWire;

    @UsedViaReflection
    private SingleTableStore(@NotNull WireIn wire) {
        assert (wire.startUse());
        try {
            this.wireType = Objects.requireNonNull(wire.read(MetaDataField.wireType).object(WireType.class));
            this.mappedBytes = (MappedBytes)wire.bytes();
            this.mappedFile = this.mappedBytes.mappedFile();
            wire.consumePadding();
            this.metadata = wire.bytes().readRemaining() > 0L ? (Metadata)Objects.requireNonNull(wire.read(MetaDataField.metadata).typedMarshallable()) : Metadata.NoMeta.INSTANCE;
            this.mappedWire = (Wire)this.wireType.apply(this.mappedBytes);
            this.mappedWire.usePadding(true);
        }
        finally {
            assert (wire.endUse());
        }
    }

    SingleTableStore(@NotNull WireType wireType, @NotNull MappedBytes mappedBytes, @NotNull T metadata) {
        this.wireType = wireType;
        this.metadata = metadata;
        this.mappedBytes = mappedBytes;
        this.mappedFile = mappedBytes.mappedFile();
        this.mappedWire = (Wire)wireType.apply(mappedBytes);
        this.mappedWire.usePadding(true);
    }

    public static <T, R> R doWithSharedLock(@NotNull File file, @NotNull Function<T, ? extends R> code, @NotNull Supplier<T> target) {
        return SingleTableStore.doWithLock(file, code, target, true);
    }

    public static <T, R> R doWithExclusiveLock(@NotNull File file, @NotNull Function<T, ? extends R> code, @NotNull Supplier<T> target) {
        return SingleTableStore.doWithLock(file, code, target, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T, R> R doWithLock(@NotNull File file, @NotNull Function<T, ? extends R> code, @NotNull Supplier<T> target, boolean shared) {
        String type = shared ? "shared" : "exclusive";
        StandardOpenOption readOrWrite = shared ? StandardOpenOption.READ : StandardOpenOption.WRITE;
        long timeoutAt = System.currentTimeMillis() + timeoutMS;
        long startMs = System.currentTimeMillis();
        try (FileChannel channel = FileChannel.open(file.toPath(), readOrWrite);){
            int count = 1;
            while (System.currentTimeMillis() < timeoutAt) {
                block36: {
                    try {
                        Throwable throwable;
                        FileLock fileLock;
                        block34: {
                            R r;
                            block35: {
                                fileLock = channel.tryLock(0x7FFFFFFFFFFFFFFEL, 1L, shared);
                                throwable = null;
                                if (fileLock == null) break block34;
                                r = code.apply(target.get());
                                if (fileLock == null) return r;
                                if (throwable == null) break block35;
                                try {
                                    fileLock.close();
                                    return r;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                    return r;
                                }
                            }
                            fileLock.close();
                            return r;
                        }
                        if (fileLock == null) break block36;
                        if (throwable != null) {
                            try {
                                fileLock.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block36;
                        } else {
                            fileLock.close();
                        }
                        break block36;
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (fileLock == null) throw throwable5;
                                if (throwable == null) {
                                    fileLock.close();
                                    throw throwable5;
                                }
                                try {
                                    fileLock.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                    }
                    catch (IOException | OverlappingFileLockException e) {
                        if (count <= 9 || !Jvm.isDebugEnabled(SingleTableStore.class)) break block36;
                        long elapsedMs = System.currentTimeMillis() - startMs;
                        String message = "Failed to acquire " + type + " lock on the table store file. Retrying, file=" + file.getAbsolutePath() + ", count=" + count + ", elapsed=" + elapsedMs + " ms";
                        Jvm.debug().on(SingleTableStore.class, "", new StackTrace(message));
                    }
                }
                int delay = Math.min(250, count * count);
                Time.sleep(delay, TimeUnit.MILLISECONDS);
                ++count;
            }
            throw new IllegalStateException("Unable to claim exclusive " + type + " lock on file " + file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't perform operation with " + type + " file lock", e);
        }
    }

    @Override
    @NotNull
    public File file() {
        return this.mappedFile.file();
    }

    @Override
    @NotNull
    public String dump() {
        return this.dump(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dump(boolean abbrev) {
        MappedBytes bytes = MappedBytes.mappedBytes(this.mappedFile);
        try {
            bytes.readLimit(bytes.realCapacity());
            String string = Wires.fromSizePrefixedBlobs((Bytes)bytes, true, abbrev);
            return string;
        }
        finally {
            bytes.releaseLast();
        }
    }

    @Override
    @NotNull
    public String shortDump() {
        this.throwExceptionIfClosed();
        return this.dump(true);
    }

    @Override
    protected void performClose() {
        this.mappedBytes.releaseLast();
    }

    @Override
    @NotNull
    public MappedBytes bytes() {
        this.throwExceptionIfClosed();
        return MappedBytes.mappedBytes(this.mappedFile);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{wireType=" + this.wireType + ", mappedFile=" + this.mappedFile + '}';
    }

    private void onCleanup() {
        this.mappedBytes.releaseLast();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write(MetaDataField.wireType).object(this.wireType);
        if (this.metadata != Metadata.NoMeta.INSTANCE) {
            wire.write(MetaDataField.metadata).typedMarshallable((WriteMarshallable)this.metadata);
        }
        wire.writeAlignTo(4, 0);
    }

    @Override
    public synchronized LongValue acquireValueFor(CharSequence key, long defaultValue) {
        if (this.mappedBytes.isClosed()) {
            throw new ClosedIllegalStateException("Closed");
        }
        StringBuilder sb = Wires.acquireStringBuilder();
        this.mappedBytes.reserve(this);
        try {
            int header;
            this.mappedBytes.readPosition(0L);
            this.mappedBytes.readLimit(this.mappedBytes.realCapacity());
            while (this.mappedWire.readDataHeader() && !Wires.isNotComplete(header = this.mappedBytes.readVolatileInt())) {
                long readPosition = this.mappedBytes.readPosition();
                int length = Wires.lengthOf(header);
                ValueIn valueIn = this.mappedWire.readEventName(sb);
                if (StringUtils.equalsCaseIgnore(key, sb)) {
                    LongValue longValue = valueIn.int64ForBinding(null);
                    return longValue;
                }
                this.mappedBytes.readPosition(readPosition + (long)length);
            }
            int safeLength = Maths.toUInt31(this.mappedBytes.realCapacity() - this.mappedBytes.readPosition());
            this.mappedBytes.writeLimit(this.mappedBytes.realCapacity());
            long start = this.mappedBytes.readPosition();
            this.mappedBytes.writePosition(start);
            long pos = this.mappedWire.enterHeader(safeLength);
            LongValue longValue = this.wireType.newLongReference().get();
            this.mappedWire.writeEventName(key).int64forBinding(defaultValue, longValue);
            this.mappedWire.writeAlignTo(4, 0);
            this.mappedWire.updateHeader(pos, false, 0);
            long end = this.mappedBytes.writePosition();
            long chuckSize = this.mappedFile.chunkSize();
            long overlapSize = this.mappedFile.overlapSize();
            long endOfChunk = (start + chuckSize - 1L) / chuckSize * chuckSize;
            if (end >= endOfChunk + overlapSize) {
                throw new IllegalStateException("Misaligned write");
            }
            LongValue longValue2 = longValue;
            return longValue2;
        }
        catch (EOFException | StreamCorruptedException e) {
            throw new IORuntimeException(e);
        }
        finally {
            this.mappedBytes.release(this);
        }
    }

    @Override
    public synchronized <T> void forEachKey(T accumulator, TableStoreIterator<T> tsIterator) {
        StringBuilder sb = Wires.acquireStringBuilder();
        this.mappedBytes.reserve(this);
        try {
            this.mappedBytes.readPosition(0L);
            this.mappedBytes.readLimit(this.mappedBytes.realCapacity());
            while (this.mappedWire.readDataHeader()) {
                int header = this.mappedBytes.readVolatileInt();
                if (Wires.isNotComplete(header)) {
                    break;
                }
                long readPosition = this.mappedBytes.readPosition();
                int length = Wires.lengthOf(header);
                ValueIn valueIn = this.mappedWire.readEventName(sb);
                tsIterator.accept(accumulator, sb, valueIn);
                this.mappedBytes.readPosition(readPosition + (long)length);
            }
        }
        catch (EOFException e) {
            throw new IORuntimeException(e);
        }
        finally {
            this.mappedBytes.release(this);
        }
    }

    @Override
    public <R> R doWithExclusiveLock(@NotNull Function<TableStore<T>, ? extends R> code) {
        return SingleTableStore.doWithExclusiveLock(this.file(), code, () -> this);
    }

    @Override
    public T metadata() {
        return this.metadata;
    }

    @Override
    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }
}

