/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;

public class CleaningThread
extends Thread {
    private static final Field THREAD_LOCALS = Jvm.getField(Thread.class, "threadLocals");
    private static final Field TABLE = Jvm.getField(THREAD_LOCALS.getType(), "table");
    private static final Field VALUE = Jvm.getField(TABLE.getType().getComponentType(), "value");

    public CleaningThread(Runnable target) {
        super(target);
    }

    public CleaningThread(Runnable target, String name) {
        super(target, name);
    }

    public static void performCleanup(Thread thread) {
        Method remove;
        WeakReference[] table;
        Object o;
        try {
            o = THREAD_LOCALS.get(thread);
            if (o == null) {
                return;
            }
            table = (WeakReference[])TABLE.get(o);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Jvm.debug().on(CleaningThreadLocal.class, e.toString());
            return;
        }
        if (table == null) {
            return;
        }
        try {
            remove = o.getClass().getDeclaredMethod("remove", ThreadLocal.class);
            remove.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        for (WeakReference reference : (WeakReference[])table.clone()) {
            try {
                Object value;
                Object key;
                Object v0 = key = reference != null ? reference.get() : null;
                if (!(key instanceof CleaningThreadLocal) || (value = VALUE.get(reference)) == null) continue;
                CleaningThreadLocal ctl = key;
                ctl.cleanup(value);
                remove.invoke(o, key);
            }
            catch (IllegalAccessException e) {
                Jvm.debug().on(CleaningThreadLocal.class, e.toString());
            }
            catch (Throwable e) {
                Jvm.debug().on(CleaningThreadLocal.class, e);
            }
        }
    }

    @Override
    public void run() {
        if (Affinity.getAffinity().cardinality() == 1) {
            Jvm.warn().on(this.getClass(), "Resetting affinity from " + Affinity.getAffinity() + " to " + AffinityLock.BASE_AFFINITY);
            Affinity.setAffinity(AffinityLock.BASE_AFFINITY);
        }
        try {
            super.run();
        }
        finally {
            CleaningThread.performCleanup(this);
        }
    }
}

