/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytesMarshaller<T> {
    public static final ClassLocal<BytesMarshaller> BYTES_MARSHALLER_CL = ClassLocal.withInitial(BytesMarshaller::new);
    private final FieldAccess[] fields;

    public BytesMarshaller(@NotNull Class<T> tClass) {
        @NotNull LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        BytesMarshaller.getAllField(tClass, map);
        this.fields = (FieldAccess[])map.values().stream().map(FieldAccess::create).toArray(FieldAccess[]::new);
    }

    public static void getAllField(@NotNull Class clazz, @NotNull Map<String, Field> map) {
        if (clazz != Object.class) {
            BytesMarshaller.getAllField(clazz.getSuperclass(), map);
        }
        for (Field field : clazz.getDeclaredFields()) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            Jvm.setAccessible(field);
            map.put(field.getName(), field);
        }
    }

    public void readMarshallable(ReadBytesMarshallable t, BytesIn in) {
        for (FieldAccess field : this.fields) {
            field.read(t, in);
        }
    }

    public void writeMarshallable(WriteBytesMarshallable t, BytesOut out) throws IllegalArgumentException, IllegalStateException, BufferOverflowException, BufferUnderflowException, ArithmeticException {
        out.indent(1);
        for (FieldAccess field : this.fields) {
            field.write(t, out);
        }
        out.indent(-1);
    }

    static class DoubleArrayFieldAccess
    extends FieldAccess {
        public DoubleArrayFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
            double[] array;
            try {
                array = (double[])this.field.get(o);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            if (array == null) {
                write.writeInt(-1);
            } else {
                write.writeInt(array.length);
                for (int i = 0; i < array.length; ++i) {
                    write.writeDouble(array[i]);
                }
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            try {
                int len = read.readInt();
                if (len == -1) {
                    this.field.set(o, null);
                } else if (len >= 0) {
                    double[] array = (double[])this.field.get(o);
                    if (array == null || array.length != len) {
                        array = new double[len];
                        this.field.set(o, array);
                    }
                    for (int i = 0; i < len; ++i) {
                        array[i] = read.readDouble();
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class DoubleFieldAccess
    extends FieldAccess {
        public DoubleFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
            try {
                write.writeDouble(this.field.getDouble(o));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            try {
                this.field.setDouble(o, read.readDouble());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class LongArrayFieldAccess
    extends FieldAccess {
        public LongArrayFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, BufferOverflowException, IllegalArgumentException {
            long[] array;
            try {
                array = (long[])this.field.get(o);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            if (array == null) {
                write.writeInt(-1);
            } else {
                write.writeInt(array.length);
                for (int i = 0; i < array.length; ++i) {
                    write.writeLong(array[i]);
                }
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            try {
                int len = read.readInt();
                if (len == -1) {
                    this.field.set(o, null);
                } else if (len >= 0) {
                    long[] array = (long[])this.field.get(o);
                    if (array == null || array.length != len) {
                        array = new long[len];
                        this.field.set(o, array);
                    }
                    for (int i = 0; i < len; ++i) {
                        array[i] = read.readLong();
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class LongFieldAccess
    extends FieldAccess {
        public LongFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
            try {
                write.writeLong(this.field.getLong(o));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            try {
                this.field.setLong(o, read.readLong());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class FloatArrayFieldAccess
    extends FieldAccess {
        public FloatArrayFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
            float[] array;
            try {
                array = (float[])this.field.get(o);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            if (array == null) {
                write.writeInt(-1);
            } else {
                write.writeInt(array.length);
                for (int i = 0; i < array.length; ++i) {
                    write.writeFloat(array[i]);
                }
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            try {
                int len = read.readInt();
                if (len == -1) {
                    this.field.set(o, null);
                } else if (len >= 0) {
                    float[] array = (float[])this.field.get(o);
                    if (array == null || array.length != len) {
                        array = new float[len];
                        this.field.set(o, array);
                    }
                    for (int i = 0; i < len; ++i) {
                        array[i] = read.readFloat();
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class FloatFieldAccess
    extends FieldAccess {
        public FloatFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
            try {
                write.writeFloat(this.field.getFloat(o));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            try {
                this.field.setFloat(o, read.readFloat());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class IntArrayFieldAccess
    extends FieldAccess {
        public IntArrayFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, BufferOverflowException, IllegalArgumentException {
            int[] array;
            try {
                array = (int[])this.field.get(o);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            if (array == null) {
                write.writeInt(-1);
            } else {
                write.writeInt(array.length);
                for (int i = 0; i < array.length; ++i) {
                    write.writeInt(array[i]);
                }
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            try {
                int len = read.readInt();
                if (len == -1) {
                    this.field.set(o, null);
                } else if (len >= 0) {
                    int[] array = (int[])this.field.get(o);
                    if (array == null || array.length != len) {
                        array = new int[len];
                        this.field.set(o, array);
                    }
                    for (int i = 0; i < len; ++i) {
                        array[i] = read.readInt();
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class IntegerFieldAccess
    extends FieldAccess {
        public IntegerFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
            try {
                write.writeInt(this.field.getInt(o));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            try {
                this.field.setInt(o, read.readInt());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class ShortFieldAccess
    extends FieldAccess {
        public ShortFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalArgumentException, BufferOverflowException, IllegalStateException {
            try {
                write.writeShort(this.field.getShort(o));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            try {
                this.field.setShort(o, read.readShort());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class CharFieldAccess
    extends FieldAccess {
        public CharFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
            try {
                char aChar = this.field.getChar(o);
                if (aChar >= '\uff81') {
                    write.writeStopBit(aChar - 65536);
                } else {
                    write.writeStopBit(aChar);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, IllegalArgumentException, BufferUnderflowException {
            try {
                this.field.setChar(o, read.readStopBitChar());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class ByteArrayFieldAccess
    extends FieldAccess {
        public ByteArrayFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
            try {
                byte[] array = (byte[])this.field.get(o);
                if (array == null) {
                    write.writeInt(-1);
                } else {
                    write.writeInt(array.length);
                    for (int i = 0; i < array.length; ++i) {
                        write.writeByte(array[i]);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException {
            try {
                int len = read.readInt();
                if (len == -1) {
                    this.field.set(o, null);
                } else if (len >= 0) {
                    byte[] array = (byte[])this.field.get(o);
                    if (array == null || array.length != len) {
                        array = new byte[len];
                        this.field.set(o, array);
                    }
                    for (int i = 0; i < len; ++i) {
                        array[i] = read.readByte();
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class ByteFieldAccess
    extends FieldAccess {
        public ByteFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
            try {
                write.writeByte(this.field.getByte(o));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalStateException, IllegalArgumentException {
            try {
                this.field.setByte(o, read.readByte());
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class BooleanFieldAccess
    extends FieldAccess {
        public BooleanFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalArgumentException, BufferOverflowException, IllegalStateException {
            try {
                write.writeBoolean(this.field.getBoolean(o));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IllegalArgumentException {
            try {
                this.field.setBoolean(o, read.readBoolean());
            }
            catch (IllegalAccessException | IllegalStateException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class MapFieldAccess
    extends FieldAccess {
        final Supplier<Map> collectionSupplier;
        private final Class<?> type;
        @NotNull
        private final Class keyType;
        @NotNull
        private final Class valueType;

        public MapFieldAccess(@NotNull Field field) {
            super(field);
            this.type = field.getType();
            this.collectionSupplier = this.type == Map.class ? LinkedHashMap::new : (this.type == SortedMap.class || this.type == NavigableMap.class ? TreeMap::new : this.newInstance(this.type));
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                @NotNull ParameterizedType pType = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pType.getActualTypeArguments();
                this.keyType = MapFieldAccess.extractClass(actualTypeArguments[0]);
                this.valueType = MapFieldAccess.extractClass(actualTypeArguments[1]);
            } else {
                this.keyType = Object.class;
                this.valueType = Object.class;
            }
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalStateException, BufferOverflowException, IllegalArgumentException, BufferUnderflowException, ArithmeticException {
            Map m = null;
            try {
                m = (Map)this.field.get(o);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            if (m == null) {
                write.writeStopBit(-1L);
                return;
            }
            write.writeStopBit(m.size());
            for (Map.Entry entry : m.entrySet()) {
                write.writeObject(this.keyType, entry.getKey());
                write.writeObject(this.valueType, entry.getValue());
            }
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalStateException, IllegalArgumentException, BufferUnderflowException, BufferOverflowException, ArithmeticException {
            try {
                LinkedHashMap m = (LinkedHashMap)this.field.get(o);
                long length = read.readStopBit();
                if (length < 0L) {
                    if (m != null) {
                        this.field.set(o, null);
                    }
                    return;
                }
                if (m == null) {
                    m = new LinkedHashMap();
                    this.field.set(o, m);
                } else {
                    m.clear();
                }
                int i = 0;
                while ((long)i < length) {
                    m.put(read.readObject(this.keyType), read.readObject(this.valueType));
                    ++i;
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class CollectionFieldAccess
    extends FieldAccess {
        final Supplier<Collection> collectionSupplier;
        @NotNull
        private final Class componentType;
        private final Class<?> type;

        public CollectionFieldAccess(@NotNull Field field) {
            super(field);
            this.type = field.getType();
            this.collectionSupplier = this.type == List.class || this.type == Collection.class ? ArrayList::new : (this.type == SortedSet.class || this.type == NavigableSet.class ? TreeSet::new : (this.type == Set.class ? LinkedHashSet::new : this.newInstance(this.type)));
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                @NotNull ParameterizedType pType = (ParameterizedType)genericType;
                Type type0 = pType.getActualTypeArguments()[0];
                this.componentType = CollectionFieldAccess.extractClass(type0);
            } else {
                this.componentType = Object.class;
            }
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalStateException, BufferOverflowException, IllegalArgumentException, BufferUnderflowException, ArithmeticException {
            try {
                Collection c = (Collection)this.field.get(o);
                if (c == null) {
                    write.writeStopBit(-1L);
                    return;
                }
                write.writeStopBit(c.size());
                if (c.isEmpty()) {
                    return;
                }
                if (c instanceof RandomAccess && c instanceof List) {
                    List l = (List)c;
                    int size = l.size();
                    for (int i = 0; i < size; ++i) {
                        write.writeObject(this.componentType, l.get(i));
                    }
                } else {
                    for (Object o2 : c) {
                        write.writeObject(this.componentType, o2);
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalStateException, ArithmeticException, IllegalArgumentException, BufferUnderflowException, BufferOverflowException {
            try {
                Collection c = (Collection)this.field.get(o);
                int length = Maths.toInt32(read.readStopBit());
                if (length < 0) {
                    if (c != null) {
                        this.field.set(o, null);
                    }
                    return;
                }
                c.clear();
                for (int i = 0; i < length; ++i) {
                    c.add(read.readObject(this.componentType));
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class ObjectArrayFieldAccess
    extends FieldAccess {
        Class componentType;

        public ObjectArrayFieldAccess(Field field) {
            super(field);
            this.componentType = field.getType().getComponentType();
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalStateException, BufferOverflowException, IllegalArgumentException, BufferUnderflowException, ArithmeticException {
            try {
                Object[] c = (Object[])this.field.get(o);
                if (c == null) {
                    write.writeStopBit(-1L);
                    return;
                }
                int size = c.length;
                write.writeStopBit(size);
                if (size == 0) {
                    return;
                }
                for (int i = 0; i < size; ++i) {
                    write.writeObject(this.componentType, c[i]);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalStateException, BufferUnderflowException, IllegalArgumentException, ArithmeticException, BufferOverflowException {
            try {
                Object[] c = (Object[])this.field.get(o);
                int length = Maths.toInt32(read.readStopBit());
                if (length < 0) {
                    if (c != null) {
                        this.field.set(o, null);
                    }
                    return;
                }
                if (c == null) {
                    c = (Object[])Array.newInstance(this.field.getType().getComponentType(), length);
                    this.field.set(o, c);
                } else if (c.length != length) {
                    c = Arrays.copyOf(c, length);
                    this.field.set(o, c);
                }
                for (int i = 0; i < length; ++i) {
                    Object o2 = c[i];
                    if (o2 instanceof BytesMarshallable) {
                        ((BytesMarshallable)o2).readMarshallable(read);
                        continue;
                    }
                    c[i] = read.readObject(this.componentType);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class BytesFieldAccess
    extends FieldAccess<Bytes> {
        public BytesFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws IllegalStateException, BufferOverflowException, IllegalArgumentException {
            BytesStore bytes;
            try {
                bytes = (BytesStore)this.field.get(o);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            if (bytes == null) {
                write.writeStopBit(-1L);
                return;
            }
            long offset = bytes.readPosition();
            long length = bytes.readRemaining();
            write.writeStopBit(length);
            try {
                write.write(bytes, offset, length);
            }
            catch (BufferUnderflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IORuntimeException, IllegalArgumentException, IllegalStateException, ArithmeticException, BufferUnderflowException, BufferOverflowException {
            try {
                Bytes bs;
                @NotNull Bytes bytes = (Bytes)this.field.get(o);
                long stopBit = read.readStopBit();
                if (stopBit == -1L) {
                    if (bytes != null) {
                        bytes.releaseLast();
                    }
                    this.field.set(o, null);
                    return;
                }
                int length = Maths.toUInt31(stopBit);
                if (bytes == null) {
                    bs = Bytes.allocateElasticOnHeap(length);
                    this.field.set(o, bs);
                } else {
                    bs = bytes;
                }
                bs.clear();
                read.read(bs, length);
                bs.readLimit(length);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class BytesMarshallableFieldAccess
    extends FieldAccess<Object> {
        public BytesMarshallableFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws BufferUnderflowException, IllegalStateException, BufferOverflowException {
            try {
                @NotNull BytesMarshallable o2 = (BytesMarshallable)this.field.get(o);
                assert (o2 != null);
                o2.writeMarshallable(write);
            }
            catch (ArithmeticException | IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
            try {
                @NotNull BytesMarshallable o2 = (BytesMarshallable)this.field.get(o);
                if (!this.field.getType().isInstance(o2)) {
                    o2 = (BytesMarshallable)ObjectUtils.newInstance(this.field.getType());
                    this.field.set(o, o2);
                }
                o2.readMarshallable(read);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static class ScalarFieldAccess
    extends FieldAccess<Object> {
        public ScalarFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, @NotNull BytesOut write) throws BufferOverflowException, IllegalStateException {
            try {
                Object o2 = this.field.get(o);
                @Nullable String s = o2 == null ? null : o2.toString();
                write.writeUtf8(s);
            }
            catch (IllegalAccessException | IllegalArgumentException | BufferUnderflowException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void setValue(Object o, @NotNull BytesIn read) throws IORuntimeException, BufferUnderflowException, IllegalStateException, ArithmeticException, IllegalArgumentException {
            try {
                @Nullable String s = read.readUtf8();
                this.field.set(o, ObjectUtils.convertTo(this.field.getType(), s));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static abstract class FieldAccess<T> {
        final Field field;

        FieldAccess(Field field) {
            this.field = field;
        }

        @NotNull
        public static Object create(@NotNull Field field) {
            Class<?> type = field.getType();
            switch (type.getName()) {
                case "boolean": {
                    return new BooleanFieldAccess(field);
                }
                case "byte": {
                    return new ByteFieldAccess(field);
                }
                case "char": {
                    return new CharFieldAccess(field);
                }
                case "short": {
                    return new ShortFieldAccess(field);
                }
                case "int": {
                    return new IntegerFieldAccess(field);
                }
                case "float": {
                    return new FloatFieldAccess(field);
                }
                case "long": {
                    return new LongFieldAccess(field);
                }
                case "double": {
                    return new DoubleFieldAccess(field);
                }
            }
            if (type.isArray()) {
                if (type.getComponentType().isPrimitive()) {
                    if (type == byte[].class) {
                        return new ByteArrayFieldAccess(field);
                    }
                    if (type == int[].class) {
                        return new IntArrayFieldAccess(field);
                    }
                    if (type == float[].class) {
                        return new FloatArrayFieldAccess(field);
                    }
                    if (type == long[].class) {
                        return new LongArrayFieldAccess(field);
                    }
                    if (type == double[].class) {
                        return new DoubleArrayFieldAccess(field);
                    }
                    throw new UnsupportedOperationException("TODO " + field.getType());
                }
                return new ObjectArrayFieldAccess(field);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return new CollectionFieldAccess(field);
            }
            if (Map.class.isAssignableFrom(type)) {
                return new MapFieldAccess(field);
            }
            if (BytesStore.class.isAssignableFrom(type)) {
                return new BytesFieldAccess(field);
            }
            if (BytesMarshallable.class.isAssignableFrom(type)) {
                return new BytesMarshallableFieldAccess(field);
            }
            return new ScalarFieldAccess(field);
        }

        @NotNull
        static Class extractClass(Type type0) {
            if (type0 instanceof Class) {
                return (Class)type0;
            }
            if (type0 instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type0).getRawType();
            }
            return Object.class;
        }

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + "{field=" + this.field + '}';
        }

        void write(Object o, BytesOut write) throws IllegalArgumentException, IllegalStateException, BufferOverflowException, ArithmeticException, BufferUnderflowException {
            write.comment(this.field.getName());
            this.getValue(o, write);
        }

        protected abstract void getValue(Object var1, BytesOut var2) throws BufferOverflowException, IllegalArgumentException, IllegalStateException, BufferUnderflowException, ArithmeticException;

        void read(Object o, BytesIn read) throws IORuntimeException {
            try {
                this.setValue(o, read);
            }
            catch (ArithmeticException | IllegalArgumentException | IllegalStateException | BufferOverflowException | BufferUnderflowException iae) {
                throw new IORuntimeException(iae);
            }
        }

        protected abstract void setValue(Object var1, BytesIn var2) throws BufferUnderflowException, IllegalArgumentException, ArithmeticException, IllegalStateException, BufferOverflowException;

        @NotNull
        protected Supplier<Map> newInstance(@NotNull Class type) {
            try {
                return (Supplier)type.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InstantiationException e) {
                throw Jvm.rethrow(e);
            }
        }
    }
}

