/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.text.ParseException;
import java.util.Comparator;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.BinarySearch;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class TestBinarySearch
extends ChronicleQueueTestBase {
    @Test
    public void testBinarySearch() throws ParseException {
        this.test(50);
    }

    @Test
    public void testBinarySearchOne() throws ParseException {
        this.test(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(int numberOfMessages) throws ParseException {
        SetTimeProvider stp = new SetTimeProvider();
        long time = 0L;
        stp.currentTimeMillis(time);
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)stp).build();){
            Throwable throwable;
            ExcerptAppender appender = queue.acquireAppender();
            for (int i = 0; i < numberOfMessages; ++i) {
                throwable = null;
                try (DocumentContext dc = appender.writingDocument();){
                    MyData myData = new MyData();
                    myData.key = i;
                    myData.value = "some value where the key=" + String.valueOf(i);
                    dc.wire().getValueOut().typedMarshallable((WriteMarshallable)myData);
                    stp.currentTimeMillis(time += 300L);
                    continue;
                }
                catch (Throwable myData) {
                    throwable = myData;
                    throw myData;
                }
            }
            Comparator comparator = (o1, o2) -> {
                long readPositionO1 = o1.bytes().readPosition();
                long readPositionO2 = o2.bytes().readPosition();
                try {
                    int compare;
                    MyData myDataO2;
                    MyData myDataO1;
                    try (DocumentContext dc = o1.readingDocument();){
                        myDataO1 = (MyData)((Object)((Object)dc.wire().getValueIn().typedMarshallable()));
                        assert (myDataO1.value != null);
                    }
                    dc = o2.readingDocument();
                    var9_6 = null;
                    try {
                        myDataO2 = (MyData)((Object)((Object)dc.wire().getValueIn().typedMarshallable()));
                        assert (myDataO2.value != null);
                    }
                    catch (Throwable throwable) {
                        var9_6 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (dc != null) {
                            if (var9_6 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable) {
                                    var9_6.addSuppressed(throwable);
                                }
                            } else {
                                dc.close();
                            }
                        }
                    }
                    int n = compare = Integer.compare(myDataO1.key, myDataO2.key);
                    return n;
                }
                finally {
                    o1.bytes().readPosition(readPositionO1);
                    o2.bytes().readPosition(readPositionO2);
                }
            };
            throwable = null;
            try (ExcerptTailer tailer = queue.createTailer();){
                for (int j = 0; j < numberOfMessages; ++j) {
                    Wire key = this.toWire(j);
                    long index = BinarySearch.search((SingleChronicleQueue)queue, (Wire)key, (Comparator)comparator);
                    tailer.moveToIndex(index);
                    try (DocumentContext documentContext = tailer.readingDocument();){
                        Assert.assertTrue((boolean)documentContext.toString().contains("some value where the key=" + j));
                    }
                    key.bytes().releaseLast();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            Wire key = this.toWire(numberOfMessages);
            Assert.assertTrue((String)"Should not find non-existent", (BinarySearch.search((SingleChronicleQueue)queue, (Wire)key, (Comparator)comparator) < 0L ? 1 : 0) != 0);
        }
        finally {
            System.gc();
            IOTools.deleteDirWithFiles((File)tmpDir);
        }
    }

    @NotNull
    private Wire toWire(int key) {
        MyData myData = new MyData();
        myData.key = key;
        myData.value = Integer.toString(key);
        Wire result = (Wire)WireType.BINARY.apply((Object)Bytes.elasticByteBuffer());
        try (DocumentContext dc = result.writingDocument();){
            dc.wire().getValueOut().typedMarshallable((WriteMarshallable)myData);
        }
        return result;
    }

    public static class MyData
    extends SelfDescribingMarshallable {
        private int key;
        private String value;

        @NotNull
        public String toString() {
            return "MyData{key=" + this.key + ", value='" + this.value + '\'' + '}';
        }
    }
}

