/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads.internal;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.internal.ThreadsThreadHolder;

public class ServicesThreadHolder
extends ThreadsThreadHolder {
    private static final boolean IGNORE_THREAD_MONITOR_EVENT_HANDLER = Jvm.getBoolean("ignoreThreadMonitorEventHandler");

    public ServicesThreadHolder(String description, long timeLimit, LongSupplier timeSupplier, Supplier<Thread> threadSupplier, BooleanSupplier logEnabled, Consumer<String> logConsumer) {
        super(description, timeLimit, timeSupplier, threadSupplier, logEnabled, logConsumer);
    }

    @Override
    public boolean isAlive() throws InvalidEventHandlerException {
        if (IGNORE_THREAD_MONITOR_EVENT_HANDLER) {
            throw new InvalidEventHandlerException("Ignoring thread monitor event handler");
        }
        return super.isAlive();
    }

    @Override
    protected long timingError() {
        return 50000000L;
    }
}

