/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public enum Slf4jExceptionHandler implements ExceptionHandler
{
    FATAL{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            LoggerFactory.getLogger(clazz).error("FATAL error " + message, thrown);
            if (!Slf4jExceptionHandler.isJUnitTest()) {
                System.exit(-1);
            }
        }
    }
    ,
    ERROR{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            LoggerFactory.getLogger(clazz).error(message, thrown);
        }
    }
    ,
    WARN{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            LoggerFactory.getLogger(clazz).warn(message, thrown);
        }
    }
    ,
    PERF{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            LoggerFactory.getLogger(clazz).info(message, thrown);
        }
    }
    ,
    DEBUG{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            LoggerFactory.getLogger(clazz).debug(message, thrown);
        }

        @Override
        public boolean isEnabled(Class clazz) {
            return LoggerFactory.getLogger(clazz).isDebugEnabled();
        }
    };


    public static Slf4jExceptionHandler valueOf(LogLevel logLevel) {
        if (logLevel == LogLevel.FATAL) {
            return FATAL;
        }
        if (logLevel == LogLevel.ERROR) {
            return ERROR;
        }
        if (logLevel == LogLevel.WARN) {
            return WARN;
        }
        return DEBUG;
    }

    private static boolean isJUnitTest() {
        for (StackTraceElement[] stackTrace : Thread.getAllStackTraces().values()) {
            for (StackTraceElement element : stackTrace) {
                if (!element.getClassName().contains(".junit")) continue;
                return true;
            }
        }
        return false;
    }
}

