/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public enum MappedUniqueTimeProvider implements TimeProvider
{
    INSTANCE;

    private static final int LAST_TIME = 128;
    private final MappedFile file;
    private final Bytes bytes;
    private TimeProvider provider = SystemTimeProvider.INSTANCE;

    private MappedUniqueTimeProvider() {
        try {
            String user = System.getProperty("user.name", "unknown");
            this.file = MappedFile.mappedFile(OS.TMP + "/.time-stamp." + user + ".dat", (long)OS.pageSize(), 0L);
            IOTools.unmonitor(this.file);
            ReferenceOwner mumtp = ReferenceOwner.temporary("mumtp");
            this.bytes = this.file.acquireBytesForWrite(mumtp, 0L);
            this.bytes.append8bit("&TSF\nTime stamp file uses for sharing a unique id\n");
            IOTools.unmonitor(this.bytes);
        }
        catch (IOException ioe) {
            throw new IORuntimeException(ioe);
        }
    }

    public MappedUniqueTimeProvider provider(TimeProvider provider) {
        this.provider = provider;
        return this;
    }

    @Override
    public long currentTimeMillis() {
        return this.provider.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        long timeus = this.provider.currentTimeMicros();
        long time0us;
        long time;
        long time0;
        while (!this.bytes.compareAndSwapLong(128L, time0, time = (time0us = (time0 = this.bytes.readVolatileLong(128L)) / 1000L) >= timeus ? (time0us + 1L) * 1000L : timeus * 1000L)) {
            Jvm.nanoPause();
        }
        return time / 1000L;
    }

    @Override
    public long currentTimeNanos() {
        long time0;
        long timeNanos5;
        long time = this.provider.currentTimeNanos();
        long time5 = time >>> 5;
        if (time5 > (timeNanos5 = (time0 = this.bytes.readVolatileLong(128L)) >>> 5) && this.bytes.compareAndSwapLong(128L, time0, time)) {
            return time;
        }
        long next;
        while (!this.bytes.compareAndSwapLong(128L, time0 = this.bytes.readVolatileLong(128L), next = time0 + 32L & 0xFFFFFFFFFFFFFFE0L)) {
            Jvm.nanoPause();
        }
        return next;
    }
}

