/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.queue.DumpQueueMain;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.single.RollCycleMultiThreadStressTest;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import org.junit.Before;
import org.junit.Test;

public class RollCycleMultiThreadStressDoubleBufferTest
extends RollCycleMultiThreadStressTest {
    private AtomicBoolean queueDumped = new AtomicBoolean(false);

    @Override
    @Test
    public void stress() throws Exception {
        super.stress();
    }

    @Before
    public void setUp() {
        this.queueDumped = new AtomicBoolean(false);
    }

    public static void main(String[] args) throws Exception {
        new RollCycleMultiThreadStressDoubleBufferTest().stress();
    }

    @Override
    protected RollCycleMultiThreadStressTest.ReaderCheckingStrategy getReaderCheckingStrategy() {
        return new DoubleBufferReaderCheckingStrategy(this.queueDumped);
    }

    static {
        System.setProperty("double_buffer", "true");
    }

    class DoubleBufferReaderCheckingStrategy
    implements RollCycleMultiThreadStressTest.ReaderCheckingStrategy {
        private final AtomicBoolean queueDumped;
        private final HashSet<Integer> unexpectedValues = new HashSet();
        private final HashSet<Integer> skippedValue = new HashSet();
        private int outOfOrderCount = 0;

        DoubleBufferReaderCheckingStrategy(AtomicBoolean queueDumped) {
            this.queueDumped = queueDumped;
        }

        @Override
        public void checkDocument(DocumentContext dc, ExcerptTailer tailer, RollingChronicleQueue queue, int lastTailerCycle, int lastQueueCycle, int expected, ValueIn valueIn) {
            for (int i = 0; i < RollCycleMultiThreadStressDoubleBufferTest.this.NUMBER_OF_INTS; ++i) {
                int v = valueIn.int32();
                if (i != 0 || v == expected) continue;
                if (!this.unexpectedValues.remove(expected)) {
                    this.skippedValue.add(expected);
                }
                if (!this.skippedValue.remove(v)) {
                    this.unexpectedValues.add(v);
                }
                ++this.outOfOrderCount;
            }
        }

        @Override
        public void postReadCheck(RollingChronicleQueue queue) {
            RollCycleMultiThreadStressDoubleBufferTest.this.LOG.info("Out-of-order count: {}", (Object)this.outOfOrderCount);
            if (this.skippedValue.size() > 0 || this.unexpectedValues.size() > 0) {
                RollCycleMultiThreadStressDoubleBufferTest.this.LOG.error("Skipped {}, Unexpected {}", this.skippedValue, this.unexpectedValues);
                if (RollCycleMultiThreadStressDoubleBufferTest.this.DUMP_QUEUE && !this.queueDumped.getAndSet(true)) {
                    DumpQueueMain.dump((File)queue.file(), (PrintStream)System.out, (long)Long.MAX_VALUE);
                }
            }
        }
    }
}

