/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.jlbh.JLBH;
import net.openhft.chronicle.core.jlbh.JLBHOptions;
import net.openhft.chronicle.core.jlbh.JLBHTask;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;

public class QueueMultiThreadedJLBHBenchmark
implements JLBHTask {
    private SingleChronicleQueue sourceQueue;
    private SingleChronicleQueue sinkQueue;
    private ExcerptTailer tailer;
    private ExcerptAppender appender;
    private Datum datum = new Datum();

    public static void main(String[] args) {
        JLBHOptions lth = new JLBHOptions().warmUpIterations(50000).iterations(1000000).throughput(100000).recordOSJitter(false).accountForCoordinatedOmission(false).skipFirstRun(true).runs(5).jlbhTask((JLBHTask)new QueueMultiThreadedJLBHBenchmark());
        new JLBH(lth).start();
    }

    public void init(JLBH jlbh) {
        IOTools.deleteDirWithFiles((String)"replica", (int)10);
        this.sourceQueue = SingleChronicleQueueBuilder.single((String)"replica").build();
        this.sinkQueue = SingleChronicleQueueBuilder.single((String)"replica").build();
        this.appender = this.sourceQueue.acquireAppender();
        this.tailer = this.sinkQueue.createTailer();
        new Thread(() -> {
            Datum datum2 = new Datum();
            while (true) {
                DocumentContext dc = this.tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (dc.wire() == null) continue;
                    datum2.readMarshallable((BytesIn)dc.wire().bytes());
                    jlbh.sample(System.nanoTime() - datum2.ts);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
        }).start();
    }

    public void run(long startTimeNS) {
        this.datum.ts = startTimeNS;
        try (DocumentContext dc = this.appender.writingDocument();){
            this.datum.writeMarshallable((BytesOut)dc.wire().bytes());
        }
    }

    public void complete() {
        this.sinkQueue.close();
        this.sourceQueue.close();
        System.exit(0);
    }

    private static class Datum
    implements BytesMarshallable {
        public long ts = 0L;
        public byte[] filler = new byte[4088];

        private Datum() {
        }

        public void readMarshallable(BytesIn bytes) throws IORuntimeException {
            this.ts = bytes.readLong();
            bytes.read(this.filler);
        }

        public void writeMarshallable(BytesOut bytes) {
            bytes.writeLong(this.ts);
            bytes.write(this.filler);
        }
    }
}

