/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.jlbh.JLBH;
import net.openhft.chronicle.core.jlbh.JLBHOptions;
import net.openhft.chronicle.core.jlbh.JLBHTask;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;

public class QueueLargeMessageJLBHBenchmark
implements JLBHTask {
    private static final int MSG_THROUGHPUT = Integer.getInteger("throughput", 50000000);
    private static final int MSG_LENGTH = Integer.getInteger("length", 1000000);
    private static final boolean MSG_DIRECT = Jvm.getBoolean((String)"direct");
    static byte[] bytesArr = new byte[MSG_LENGTH];
    static Bytes bytesArr2 = Bytes.allocateDirect((long)MSG_LENGTH);
    private SingleChronicleQueue sourceQueue;
    private SingleChronicleQueue sinkQueue;
    private ExcerptTailer tailer;
    private ExcerptAppender appender;
    private JLBH jlbh;

    public static void main(String[] args) {
        int throughput = MSG_THROUGHPUT / MSG_LENGTH;
        int warmUp = Math.min(50 * throughput, 12000);
        int iterations = Math.min(20 * throughput, 100000);
        JLBHOptions lth = new JLBHOptions().warmUpIterations(warmUp).iterations(iterations).throughput(throughput).recordOSJitter(false).skipFirstRun(true).runs(5).jlbhTask((JLBHTask)new QueueLargeMessageJLBHBenchmark());
        new JLBH(lth).start();
    }

    public void init(JLBH jlbh) {
        IOTools.deleteDirWithFiles((String)"large", (int)3);
        this.sourceQueue = SingleChronicleQueueBuilder.single((String)"large").blockSize(0x40000000L).build();
        this.sinkQueue = SingleChronicleQueueBuilder.single((String)"large").blockSize(0x40000000L).build();
        this.appender = this.sourceQueue.acquireAppender();
        this.tailer = this.sinkQueue.createTailer();
        this.jlbh = jlbh;
    }

    public void run(long startTimeNS) {
        Bytes bytes;
        if (MSG_DIRECT) {
            bytesArr2.readLimit((long)MSG_LENGTH);
        }
        try (DocumentContext dc = this.appender.writingDocument();){
            bytes = dc.wire().bytes();
            bytes.writeLong(startTimeNS);
            bytes.writeInt(bytes.length());
            if (MSG_DIRECT) {
                bytes.write((BytesStore)bytesArr2);
            } else {
                bytes.write(bytesArr);
            }
        }
        dc = this.tailer.readingDocument();
        var4_3 = null;
        try {
            if (dc.wire() != null) {
                bytes = dc.wire().bytes();
                long start = bytes.readLong();
                int length = bytes.readInt();
                assert (length == MSG_LENGTH);
                if (MSG_DIRECT) {
                    bytes.read(bytesArr2.clear(), length);
                } else {
                    bytes.read(bytesArr);
                }
                this.jlbh.sample(System.nanoTime() - start);
            }
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (dc != null) {
                if (var4_3 != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    dc.close();
                }
            }
        }
    }

    public void complete() {
        this.sinkQueue.close();
        this.sourceQueue.close();
        System.exit(0);
    }
}

