/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ToEndTest
extends ChronicleQueueTestBase {
    private static final long FIVE_SECONDS = TimeUnit.SECONDS.toMicros(5L);
    private static List<File> pathsToDelete = new LinkedList<File>();
    long lastCycle;
    private Map<ExceptionKey, Integer> exceptionKeyIntegerMap;

    @AfterClass
    public static void afterClass() {
        for (File file : pathsToDelete) {
            IOTools.shallowDeleteDirWithFiles((File)file);
        }
    }

    @Test
    public void missingCyclesToEndTest() {
        String path = OS.getTarget() + "/missingCyclesToEndTest-" + Time.uniqueId();
        IOTools.shallowDeleteDirWithFiles((String)path);
        SetTimeProvider timeProvider = new SetTimeProvider();
        long now = 1470757797000L;
        long timeIncMs = 1001L;
        timeProvider.currentTimeMillis(now);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)timeProvider).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(1));
            timeProvider.currentTimeMillis(now += timeIncMs);
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(2));
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(3));
            ExcerptTailer tailer = queue.createTailer().toEnd();
            try (DocumentContext dc = tailer.readingDocument();){
                if (dc.isPresent()) {
                    Assert.fail((String)("Should be at the end of the queue but dc.isPresent and we read: " + dc.wire().read("msg").int32()));
                }
            }
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(4));
            dc = tailer.readingDocument();
            var12_14 = null;
            try {
                Assert.assertTrue((String)"Should be able to read entry in this cycle. Got NoDocumentContext.", (boolean)dc.isPresent());
                int i = dc.wire().read("msg").int32();
                Assert.assertEquals((String)("Should've read 4, instead we read: " + i), (long)4L, (long)i);
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var12_14 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var12_14.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            tailer.toStart();
            for (int j = 1; j <= 4; ++j) {
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertTrue((boolean)dc.isPresent());
                    int i = dc.wire().read("msg").int32();
                    Assert.assertEquals((long)j, (long)i);
                    continue;
                }
            }
            dc = tailer.readingDocument();
            var12_14 = null;
            try {
                if (dc.isPresent()) {
                    Assert.fail((String)("Should be at the end of the queue but dc.isPresent and we read: " + String.valueOf(dc.wire().read("msg").int32())));
                }
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var12_14 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var12_14.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(5));
            timeProvider.currentTimeMillis(now += timeIncMs * 5L);
            dc = tailer.readingDocument();
            var12_14 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((long)5L, (long)dc.wire().read("msg").int32());
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var12_14 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var12_14.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var12_14 = null;
            try {
                Assert.assertFalse((boolean)dc.isPresent());
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var12_14 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var12_14.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void tailerToEndIncreasesRefCount() throws NoSuchFieldException, IllegalAccessException {
        String path = OS.getTarget() + "/toEndIncRefCount-" + Time.uniqueId();
        IOTools.shallowDeleteDirWithFiles((String)path);
        SetTimeProvider time = new SetTimeProvider();
        long now = System.currentTimeMillis();
        time.currentTimeMillis(now);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((String)path).testBlockSize().rollCycle((RollCycle)RollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)time).build();){
            StoreAppender appender = (StoreAppender)queue.acquireAppender();
            Field storeF1 = StoreAppender.class.getDeclaredField("store");
            Jvm.setAccessible((AccessibleObject)storeF1);
            SingleChronicleQueueStore store1 = (SingleChronicleQueueStore)storeF1.get(appender);
            appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(1));
            StoreTailer tailer = (StoreTailer)queue.createTailer();
            tailer.toEnd();
            Field storeF2 = StoreTailer.class.getDeclaredField("store");
            Jvm.setAccessible((AccessibleObject)storeF2);
            SingleChronicleQueueStore store2 = (SingleChronicleQueueStore)storeF2.get(tailer);
            Assert.assertFalse((boolean)store2.isClosed());
        }
    }

    @Test
    public void toEndTest() {
        File baseDir = this.getTmpDir();
        ArrayList<Integer> results = new ArrayList<Integer>();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)baseDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            this.checkOneFile(baseDir);
            ExcerptAppender appender = queue.acquireAppender();
            this.checkOneFile(baseDir);
            int i = 0;
            while (i < 10) {
                int j = i++;
                appender.writeDocument(wire -> wire.write((CharSequence)"msg").int32(j));
            }
            this.checkOneFile(baseDir);
            ExcerptTailer tailer = queue.createTailer();
            this.checkOneFile(baseDir);
            ExcerptTailer atEnd = tailer.toEnd();
            Assert.assertEquals((long)10L, (long)queue.rollCycle().toSequenceNumber(atEnd.index()));
            this.checkOneFile(baseDir);
            this.fillResults(atEnd, results);
            this.checkOneFile(baseDir);
            Assert.assertEquals((long)0L, (long)results.size());
            tailer.toStart();
            this.checkOneFile(baseDir);
            this.fillResults(tailer, results);
            Assert.assertEquals((long)10L, (long)results.size());
            this.checkOneFile(baseDir);
        }
        System.gc();
        pathsToDelete.add(baseDir);
    }

    @Test
    public void toEndBeforeWriteTest() {
        File baseDir = this.getTmpDir();
        IOTools.shallowDeleteDirWithFiles((File)baseDir);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)baseDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST_DAILY).build();){
            this.checkOneFile(baseDir);
            ExcerptAppender appender = queue.acquireAppender();
            this.checkOneFile(baseDir);
            ExcerptTailer tailer = queue.createTailer();
            this.checkOneFile(baseDir);
            ExcerptTailer tailer2 = queue.createTailer();
            this.checkOneFile(baseDir);
            tailer.toEnd();
            this.checkOneFile(baseDir);
            tailer2.toEnd();
            this.checkOneFile(baseDir);
        }
        System.gc();
        pathsToDelete.add(baseDir);
    }

    @Test
    public void toEndAfterWriteTest() {
        File file = this.getTmpDir();
        IOTools.shallowDeleteDirWithFiles((File)file);
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(1470757797000L);
        try (SingleChronicleQueue wqueue = SingleChronicleQueueBuilder.binary((File)file).testBlockSize().rollCycle((RollCycle)RollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)stp).build();){
            ExcerptAppender appender = wqueue.acquireAppender();
            for (int i = 0; i < 10; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().getValueOut().text("hi-" + i);
                    this.lastCycle = wqueue.rollCycle().toCycle(dc.index());
                }
                stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            }
        }
        var4_4 = null;
        try (SingleChronicleQueue rqueue = SingleChronicleQueueBuilder.binary((File)file).testBlockSize().rollCycle((RollCycle)RollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)stp).build();){
            ExcerptTailer tailer = rqueue.createTailer();
            stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            while (tailer.readText() != null) {
            }
            Assert.assertNull((Object)tailer.readText());
            stp.currentTimeMillis(stp.currentTimeMillis() + 1000L);
            ExcerptTailer tailer1 = rqueue.createTailer();
            ExcerptTailer excerptTailer = tailer1.toEnd();
            Assert.assertNull((Object)excerptTailer.readText());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        System.gc();
        pathsToDelete.add(file);
    }

    @Test
    public void shouldReturnZeroForEmptyQueue() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        try (SingleChronicleQueue queue = this.createQueue(timeProvider);){
            Assert.assertEquals((long)0L, (long)this.getNextWriteIndex(queue));
        }
    }

    @Ignore(value="Broken by https://github.com/OpenHFT/Chronicle-Queue/issues/825")
    @Test
    public void shouldReturnZeroForEmptyPretouchedQueue() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        try (SingleChronicleQueue queue = this.createQueue(timeProvider);){
            this.pretouchQueue(queue);
            Assert.assertEquals((long)Long.MIN_VALUE, (long)this.lastWriteIndex(queue));
            timeProvider.advanceMicros(FIVE_SECONDS);
            this.pretouchQueue(queue);
            Assert.assertEquals((long)Long.MIN_VALUE, (long)this.lastWriteIndex(queue));
        }
    }

    @Ignore(value="Broken by https://github.com/OpenHFT/Chronicle-Queue/issues/825")
    @Test
    public void shouldReturnZeroForQueueWithOnlyMetadata() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.advanceMicros(FIVE_SECONDS);
        try (SingleChronicleQueue queue = this.createQueue(timeProvider);){
            this.writeMetadataToQueue(queue);
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: !short 1000, format: yyyyMMdd-HHmmss'T4', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n# position: 180, header: 0\n--- !!data #binary\nlisting.highestCycle: 5\n# position: 216, header: 1\n--- !!data #binary\nlisting.lowestCycle: 5\n# position: 256, header: 2\n--- !!data #binary\nlisting.modCount: 1\n# position: 288, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 328, header: 4\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n# position: 368, header: 5\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 416, header: 6\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n...\n# 130596 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    0,\n    0\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 196,\n    lastIndex: 0\n  },\n  dataFormat: 1\n}\n# position: 196, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 32, used: 1\n  488,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 488, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 32, used: 0\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 776, header: -1\n--- !!meta-data #binary\n\"\": hello!\n...\n# 130280 bytes remaining\n", (Object)queue.dump());
            Assert.assertEquals((long)Long.MIN_VALUE, (long)this.lastWriteIndex(queue));
        }
    }

    @Test
    public void shouldReturnNextWriteIndexForNonEmptyRolledByPretouch() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.advanceMicros(FIVE_SECONDS);
        try (SingleChronicleQueue queue = this.createQueue(timeProvider);){
            this.writeExcerptToQueue(queue);
            long nextIndex = this.getNextWriteIndex(queue);
            timeProvider.advanceMicros(FIVE_SECONDS);
            this.pretouchQueue(queue);
            Assert.assertEquals((long)nextIndex, (long)this.getNextWriteIndex(queue));
        }
    }

    @Ignore(value="Broken by https://github.com/OpenHFT/Chronicle-Queue/issues/825")
    @Test
    public void shouldReturnNextWriteIndexForNonEmptyRolledByMetadata() {
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.advanceMicros(FIVE_SECONDS);
        try (SingleChronicleQueue queue = this.createQueue(timeProvider);){
            this.writeExcerptToQueue(queue);
            long nextIndex = this.lastWriteIndex(queue);
            timeProvider.advanceMicros(FIVE_SECONDS);
            this.writeMetadataToQueue(queue);
            Assert.assertEquals((long)nextIndex, (long)this.lastWriteIndex(queue));
        }
    }

    private long getNextWriteIndex(SingleChronicleQueue queue) {
        try (ExcerptTailer tailer = queue.createTailer().toEnd();){
            long l = tailer.index();
            return l;
        }
    }

    /*
     * Exception decompiling
     */
    private long lastWriteIndex(SingleChronicleQueue queue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeExcerptToQueue(SingleChronicleQueue queue) {
        try (ExcerptAppender excerptAppender = queue.acquireAppender();){
            excerptAppender.writeText((CharSequence)"hello!");
        }
    }

    private void writeMetadataToQueue(SingleChronicleQueue queue) {
        try (ExcerptAppender excerptAppender = queue.acquireAppender();
             DocumentContext documentContext = excerptAppender.writingDocument(true);){
            documentContext.wire().write().text("hello!");
        }
    }

    private void pretouchQueue(SingleChronicleQueue queue) {
        try (ExcerptAppender excerptAppender = queue.acquireAppender();){
            excerptAppender.pretouch();
        }
    }

    private SingleChronicleQueue createQueue(SetTimeProvider timeProvider) {
        File queueDir = this.getTmpDir();
        pathsToDelete.add(queueDir);
        return SingleChronicleQueueBuilder.binary((File)queueDir).testBlockSize().rollCycle((RollCycle)RollCycles.TEST4_SECONDLY).timeProvider((TimeProvider)timeProvider).build();
    }

    private void checkOneFile(@NotNull File baseDir) {
        Object[] files = baseDir.list((d, n) -> n.endsWith(".cq4"));
        if (files == null || files.length == 0) {
            return;
        }
        if (files.length == 1) {
            Assert.assertTrue((String)files[0], (boolean)files[0].startsWith("2"));
        } else {
            Assert.fail((String)("Too many files " + Arrays.toString(files)));
        }
    }

    @NotNull
    private List<Integer> fillResults(@NotNull ExcerptTailer tailer, @NotNull List<Integer> results) {
        for (int i = 0; i < 10; ++i) {
            try (DocumentContext documentContext = tailer.readingDocument();){
                if (!documentContext.isPresent()) break;
                results.add(documentContext.wire().read("msg").int32());
                continue;
            }
        }
        return results;
    }

    @Before
    public void enableCloseableTracing() {
        AbstractCloseable.enableCloseableTracing();
    }

    @After
    public void assertCloseablesClosed() {
        AbstractCloseable.assertCloseablesClosed();
    }
}

