/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class InternalAppenderWriteBytesTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        @NotNull Bytes test = Bytes.from((String)"hello world");
        Bytes result = Bytes.elasticByteBuffer();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir("")).timeProvider(() -> 0L).build();){
            ExcerptAppender appender = q.acquireAppender();
            appender.writeBytes(test);
            ((InternalAppender)appender).writeBytes(1L, (BytesStore)test);
            ExcerptTailer tailer = q.createTailer();
            tailer.readBytes(result);
            Assert.assertTrue((boolean)"hello world".contentEquals((CharSequence)result));
            result.clear();
            tailer.readBytes(result);
            Assert.assertTrue((boolean)"hello world".contentEquals((CharSequence)result));
            result.clear();
        }
        finally {
            result.releaseLast();
            test.releaseLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void test2() {
        @NotNull Bytes test = Bytes.from((String)"hello world");
        Bytes result = Bytes.elasticByteBuffer();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir("")).timeProvider(() -> 0L).build();){
            ExcerptAppender appender = q.acquireAppender();
            appender.writeBytes(test);
            ExcerptTailer tailer = q.createTailer();
            ((InternalAppender)appender).writeBytes(0L, (BytesStore)test);
            tailer.readBytes(result);
            Assert.assertTrue((boolean)"hello world".contentEquals((CharSequence)result));
            Assert.assertEquals((long)1L, (long)tailer.index());
            result.clear();
            ((InternalAppender)appender).writeBytes(2L, (BytesStore)test);
        }
        finally {
            result.releaseLast();
            test.releaseLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test3() {
        @NotNull Bytes test = Bytes.from((String)"hello world");
        Bytes result = Bytes.elasticByteBuffer();
        try {
            SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir("")).timeProvider(() -> 0L).build();
            Throwable throwable = null;
            try {
                ExcerptAppender appender = q.acquireAppender();
                appender.writeBytes(test);
                ExcerptTailer tailer = q.createTailer();
                ((InternalAppender)appender).writeBytes(0L, (BytesStore)test);
                try (DocumentContext documentContext = tailer.readingDocument();){
                    result.write((BytesStore)documentContext.wire().bytes());
                }
                Assert.assertTrue((boolean)"hello world".contentEquals((CharSequence)result));
                Assert.assertEquals((long)1L, (long)tailer.index());
                result.clear();
                ((InternalAppender)appender).writeBytes(1L, (BytesStore)test);
                try {
                    DocumentContext dc = tailer.readingDocument();
                    var8_11 = null;
                    try {
                        try {
                            dc.rollbackOnClose();
                            throw new NullPointerException();
                        }
                        catch (Throwable throwable2) {
                            var8_11 = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (dc != null) {
                            if (var8_11 != null) {
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable4) {
                                    var8_11.addSuppressed(throwable4);
                                }
                            } else {
                                dc.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.assertEquals((long)1L, (long)tailer.index());
                    result.clear();
                    ((InternalAppender)appender).writeBytes(2L, (BytesStore)test);
                    if (q != null) {
                        if (throwable != null) {
                            try {
                                q.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            q.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                try {
                    throwable = throwable6;
                    throw throwable6;
                }
                catch (Throwable throwable7) {
                    if (q != null) {
                        if (throwable != null) {
                            try {
                                q.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            q.close();
                        }
                    }
                    throw throwable7;
                }
            }
        }
        finally {
            result.releaseLast();
            test.releaseLast();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testJumpingAMessageThrowsAIllegalStateException() {
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir("q")).rollCycle((RollCycle)RollCycles.MINUTELY).timeProvider(() -> 0L).build();
             ExcerptAppender appender = q.acquireAppender();){
            appender.writeText((CharSequence)"hello");
            appender.writeText((CharSequence)"hello");
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().bytes().writeLong(1L);
            }
            long l = appender.lastIndexAppended();
            RollCycle rollCycle = q.rollCycle();
            long index = rollCycle.toIndex(rollCycle.toCycle(l) + 1, 1L);
            ((InternalAppender)appender).writeBytes(index, (BytesStore)Bytes.from((String)"text"));
        }
    }
}

