/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.values.Array;
import net.openhft.chronicle.values.Values;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.junit.Assert;
import org.junit.Test;

public class IndexForIDTest {
    private int count;
    private ChronicleQueue queue;

    private static void applyFlyweight(Facade datum, long datumSize, DocumentContext dc) {
        Wire wire = dc.wire();
        Bytes bytes = wire.bytes();
        datum.bytesStore((BytesStore)bytes, bytes.readPosition(), datumSize);
    }

    void producer() {
        Facade datum = (Facade)Values.newNativeReference(Facade.class);
        long datumSize = datum.maxSize();
        Assert.assertEquals((long)512L, (long)datumSize);
        try (ExcerptAppender appender = this.queue.acquireAppender();
             LongValue value = this.queue.indexForId("producer");){
            value.setOrderedValue(Long.MAX_VALUE);
            Thread pretoucher = new Thread(() -> {
                ExcerptAppender appender0 = this.queue.acquireAppender();
                Thread thread = Thread.currentThread();
                while (!thread.isInterrupted()) {
                    appender0.pretouch();
                    Jvm.pause((long)10L);
                }
            });
            pretoucher.setDaemon(true);
            pretoucher.start();
            for (int i = 0; i < this.count; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    Wire wire = dc.wire();
                    Bytes bytes = wire.bytes();
                    datum.bytesStore((BytesStore)bytes, bytes.writePosition(), datumSize);
                    bytes.writeSkip(datumSize);
                    datum.setProducerTime(System.nanoTime());
                    continue;
                }
            }
            pretoucher.interrupt();
            try {
                pretoucher.join(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    void first() {
        this.copy("producer", Facade::setFirstTime, "first");
    }

    void mid() {
        this.copy("first", Facade::setMidTime, "mid");
    }

    void end() {
        this.copy("mid", Facade::setEndTime, "end");
    }

    private void copy(String fromID, TimeSetter setTime, String toID) {
        Facade datum = (Facade)Values.newNativeReference(Facade.class);
        long datumSize = datum.maxSize();
        try (ExcerptTailer tailer = this.queue.createTailer();
             LongValue fromIndex = this.queue.indexForId(fromID);
             LongValue toIndex = this.queue.indexForId(toID);){
            for (int i = 0; i < this.count; ++i) {
                try (DocumentContext dc = tailer.readingDocument();){
                    if (!dc.isPresent()) {
                        Jvm.nanoPause();
                        --i;
                        continue;
                    }
                    long index = dc.index();
                    while (index > fromIndex.getVolatileValue()) {
                        Jvm.nanoPause();
                    }
                    IndexForIDTest.applyFlyweight(datum, datumSize, dc);
                    setTime.apply(datum, System.nanoTime());
                    toIndex.setVolatileValue(index);
                    continue;
                }
            }
        }
    }

    @Test
    public void staged() {
        Path staged = IOTools.createTempDirectory((String)"staged");
        this.count = 1000000;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((Path)staged).build();){
            this.queue = queue;
            ((Stream)Stream.of(this::producer, this::first, this::mid, this::end).parallel()).forEach(Runnable::run);
        }
        IOTools.deleteDirWithFiles((File)staged.toFile(), (int)3);
    }

    static interface Facade
    extends Byteable {
        public long getProducerTime();

        public void setProducerTime(long var1);

        public long getFirstTime();

        public void setFirstTime(long var1);

        public long getMidTime();

        public void setMidTime(long var1);

        public long getEndTime();

        public void setEndTime(long var1);

        @Array(length=60)
        public double getValueAt(int var1);

        public void setValueAt(int var1, double var2);
    }

    @FunctionalInterface
    static interface TimeSetter {
        public void apply(Facade var1, long var2);
    }
}

