/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.InternalAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ChronicleQueueIndexTest
extends ChronicleQueueTestBase {
    @Test
    public void checkTheEOFisWrittenToPreQueueFile() {
        this.checkTheEOFisWrittenToPreQueueFileInner(appender -> appender.writeBytes(appender.queue().rollCycle().toIndex(1, 0L), (BytesStore)Bytes.from((String)"Hello World 1")), (tp, rc) -> {}, appender -> appender.writeBytes(appender.queue().rollCycle().toIndex(3, 0L), (BytesStore)Bytes.from((String)"Hello World 2")));
    }

    @Test
    public void checkTheEOFisWrittenToPreQueueFileWritingDocumentMetadata() {
        Consumer<InternalAppender> writer = appender -> {
            try (DocumentContext wd = appender.writingDocument(true);){
                wd.wire().write((CharSequence)"key").writeDouble(1.0);
            }
        };
        this.checkTheEOFisWrittenToPreQueueFileInner(writer, (tp, rollCycle) -> tp.advanceMillis((long)(2 * rollCycle.lengthInMillis())), writer);
    }

    @Test
    public void checkTheEOFisWrittenToPreQueueFileWritingDocument() {
        Consumer<InternalAppender> writer = appender -> {
            try (DocumentContext wd = appender.writingDocument();){
                wd.wire().write((CharSequence)"key").writeDouble(1.0);
            }
        };
        this.checkTheEOFisWrittenToPreQueueFileInner(writer, (tp, rollCycle) -> tp.advanceMillis((long)(2 * rollCycle.lengthInMillis())), writer);
    }

    private void checkTheEOFisWrittenToPreQueueFileInner(Consumer<InternalAppender> writer1, BiConsumer<SetTimeProvider, RollCycle> tpConsumer, Consumer<InternalAppender> writer2) {
        InternalAppender appender;
        SetTimeProvider tp = new SetTimeProvider(1000000000L);
        File file1 = this.getTmpDir();
        RollCycles rollCycle = RollCycles.DEFAULT;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)tp).testBlockSize().build();){
            appender = (InternalAppender)queue.acquireAppender();
            writer1.accept(appender);
            Assert.assertFalse((boolean)this.hasEOFAtEndOfFile(file1));
        }
        tpConsumer.accept(tp, (RollCycle)rollCycle);
        queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)tp).testBlockSize().build();
        var8_8 = null;
        try {
            appender = (InternalAppender)queue.acquireAppender();
            Assert.assertFalse((boolean)this.hasEOFAtEndOfFile(file1));
            writer2.accept(appender);
            Assert.assertTrue((boolean)this.hasEOFAtEndOfFile(file1));
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var8_8 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void checkTheEOFisWrittenToPreQueueFileAfterPreTouch() {
        ExcerptAppender appender2;
        Assume.assumeTrue((!OS.isWindows() ? 1 : 0) != 0);
        SetTimeProvider tp = new SetTimeProvider(1L);
        File file1 = this.getTmpDir();
        RollCycles rollCycle = RollCycles.DEFAULT;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)tp).testBlockSize().build();){
            appender2 = queue.acquireAppender();
            appender2.writeText((CharSequence)"Hello World 1");
            Assert.assertFalse((boolean)this.hasEOFAtEndOfFile(file1));
        }
        tp.advanceMillis(TimeUnit.DAYS.toMillis(1L));
        queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)tp).testBlockSize().build();
        var5_5 = null;
        try {
            queue.acquireAppender().pretouch();
        }
        catch (Throwable appender2) {
            var5_5 = appender2;
            throw appender2;
        }
        finally {
            if (queue != null) {
                if (var5_5 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable appender2) {
                        var5_5.addSuppressed(appender2);
                    }
                } else {
                    queue.close();
                }
            }
        }
        tp.advanceMillis((long)rollCycle.lengthInMillis());
        queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)tp).build();
        var5_5 = null;
        try {
            appender2 = queue.acquireAppender();
            appender2.writeText((CharSequence)"Hello World 2");
            Assert.assertTrue((boolean)this.hasEOFAtEndOfFile(file1));
            try (SingleChronicleQueue queue123 = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)rollCycle).timeProvider((TimeProvider)tp).build();){
                ExcerptTailer tailer = queue123.createTailer();
                Assert.assertEquals((Object)"Hello World 1", (Object)tailer.readText());
                Assert.assertEquals((Object)"Hello World 2", (Object)tailer.readText());
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var5_5 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    private boolean hasEOFAtEndOfFile(File file) {
        try (SingleChronicleQueue queue123 = SingleChronicleQueueBuilder.builder().path(file).build();){
            String dump = queue123.dump();
            boolean bl = dump.contains(" EOF") && dump.contains("--- !!not-ready-meta-data! #binary");
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexQueue() {
        Bytes hello_world;
        InternalAppender appender;
        File file1 = this.getTmpDir();
        file1.deleteOnExit();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)RollCycles.DEFAULT).build();){
            appender = (InternalAppender)queue.acquireAppender();
            hello_world = Bytes.from((String)"Hello World 1");
            appender.writeBytes(RollCycles.DEFAULT.toIndex(18264, 0L), (BytesStore)hello_world);
            hello_world.releaseLast();
            hello_world = Bytes.from((String)"Hello World 2");
            appender.writeBytes(RollCycles.DEFAULT.toIndex(18264, 1L), (BytesStore)hello_world);
            hello_world.releaseLast();
        }
        queue = SingleChronicleQueueBuilder.builder().path(file1).rollCycle((RollCycle)RollCycles.DEFAULT).build();
        var3_3 = null;
        try {
            appender = (InternalAppender)queue.acquireAppender();
            hello_world = Bytes.from((String)"Hello World 3");
            appender.writeBytes(RollCycles.DEFAULT.toIndex(18265, 0L), (BytesStore)hello_world);
            hello_world.releaseLast();
            ExcerptTailer tailer = queue.createTailer();
            Bytes forRead = Bytes.elasticByteBuffer();
            try {
                ArrayList<String> results = new ArrayList<String>();
                while (tailer.readBytes(forRead)) {
                    results.add(forRead.to8bitString());
                    forRead.clear();
                }
                Assert.assertTrue((String)((Object)results).toString(), (boolean)results.contains("Hello World 1"));
                Assert.assertTrue((boolean)results.contains("Hello World 2"));
                Assert.assertTrue((boolean)results.contains("Hello World 3"));
            }
            finally {
                forRead.releaseLast();
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (queue != null) {
                if (var3_3 != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    queue.close();
                }
            }
        }
    }

    @Test
    public void read5thMessageTest() {
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(SystemTimeProvider.CLOCK.currentTimeMillis());
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)stp).build();){
            int cycle;
            ExcerptAppender appender = queue.acquireAppender();
            int i = 0;
            String msg = "world ";
            for (int j = 0; j < 8; ++j) {
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().write((CharSequence)"hello").text(msg + i++);
                }
                stp.advanceMillis(1500L);
            }
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext documentContext = tailer.readingDocument();){
                long index = documentContext.index();
                cycle = queue.rollCycle().toCycle(index);
            }
            long index = queue.rollCycle().toIndex(cycle, 5L);
            Assert.assertFalse((boolean)tailer.moveToIndex(index));
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertFalse((boolean)dc.isPresent());
            }
            long index0 = queue.rollCycle().toIndex(cycle, 0L);
            Assert.assertTrue((boolean)tailer.moveToIndex(index0));
            for (int j = 0; j < 4; ++j) {
                try (DocumentContext dc = tailer.readingDocument();){
                    Assert.assertTrue((boolean)dc.isPresent());
                    continue;
                }
            }
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isPresent());
                String s5 = dc.wire().read("hello").text();
                Assert.assertEquals((Object)(msg + 4), (Object)s5);
            }
        }
    }

    @Test
    public void writeReadMetadata() {
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            ExcerptTailer tailer = queue.createTailer();
            boolean metadata = true;
            try (DocumentContext dc = appender.writingDocument(metadata);){
                dc.wire().write((CharSequence)"a").text("hello");
            }
            dc = tailer.readingDocument(metadata);
            var7_9 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_9 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    private void driver0(String[] strings, boolean[] meta, long millis) {
        assert (((String[])strings).length == meta.length);
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.getTmpDir()).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            ExcerptTailer withMetaTailer = queue.createTailer();
            ExcerptTailer withoutMetaTailer = queue.createTailer();
            for (int i = 0; i < ((String[])strings).length; ++i) {
                try (DocumentContext dc = appender.writingDocument(meta[i]);){
                    dc.wire().write((CharSequence)"key").text((String)strings[i]);
                }
                Thread.sleep(millis);
            }
            int allReads = 0;
            for (DocumentContext string : strings) {
                try (DocumentContext dc = withMetaTailer.readingDocument(true);){
                    if (!dc.isPresent()) break;
                    ++allReads;
                    String str = dc.wire().read("key").text();
                    System.out.println("M+D Read: " + str + ", vs " + (String)string + ", index = " + dc.index());
                    Assert.assertTrue((boolean)str.equals(string));
                }
            }
            Assert.assertTrue((allReads == ((DocumentContext)strings).length ? 1 : 0) != 0);
            int dataReads = 0;
            for (int i = 0; i < ((DocumentContext)strings).length; ++i) {
                if (meta[i]) continue;
                try (DocumentContext dc = withoutMetaTailer.readingDocument(false);){
                    if (!dc.isPresent()) break;
                    ++dataReads;
                    String str = dc.wire().read("key").text();
                    System.out.println("D Read: " + str + ", vs " + (String)strings[i] + ", index = " + dc.index());
                    Assert.assertTrue((boolean)str.equals(strings[i]));
                    continue;
                }
            }
            int expectedData = 0;
            for (boolean b : meta) {
                if (b) continue;
                ++expectedData;
            }
            Assert.assertTrue((expectedData == dataReads ? 1 : 0) != 0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void driver(String[] strings, boolean[] meta) {
        this.driver0(strings, meta, 0L);
        this.driver0(strings, meta, 1500L);
    }

    @Test
    public void D() {
        this.driver(new String[]{"data-1"}, new boolean[]{false});
    }

    @Test
    public void M() {
        this.driver(new String[]{"data-1"}, new boolean[]{true});
    }

    @Test
    public void DDD() {
        this.driver(new String[]{"data-1", "data-2", "data-3"}, new boolean[]{false, false, false});
    }

    @Test
    public void DDM() {
        this.driver(new String[]{"data-1", "data-2", "meta-1"}, new boolean[]{false, false, true});
    }

    @Test
    public void DMD() {
        this.driver(new String[]{"data-1", "meta-1", "data-2"}, new boolean[]{false, true, false});
    }

    @Test
    public void DMM() {
        this.driver(new String[]{"data-1", "meta-1", "meta-2"}, new boolean[]{false, true, true});
    }

    @Test
    public void MMM() {
        this.driver(new String[]{"meta-1", "meta-2", "meta-3"}, new boolean[]{true, true, true});
    }

    @Test
    public void MMD() {
        this.driver(new String[]{"meta-1", "meta-2", "data-1"}, new boolean[]{true, true, false});
    }

    @Test
    public void MDM() {
        this.driver(new String[]{"meta-1", "data-1", "meta-2"}, new boolean[]{true, false, true});
    }

    @Test
    public void MDD() {
        this.driver(new String[]{"meta-1", "data-1", "data-2"}, new boolean[]{true, false, false});
    }
}

