/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.watcher;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import net.openhft.chronicle.core.watcher.JMXFileManager;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.watcher.QueueFileManagerMBean;

public class QueueFileManager
extends JMXFileManager
implements QueueFileManagerMBean {
    private final Set<String> files = new ConcurrentSkipListSet<String>();
    private static final long TIME_OUT = 5000L;
    private String tableStore;
    private long lastUpdate = 0L;
    private String lastHeader;

    public QueueFileManager(String basePath, String relativePath) {
        super(basePath, relativePath);
    }

    protected String type() {
        return "queues";
    }

    public void onRemoved(String filename) {
        this.files.remove(filename);
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Override
    public Set<String> getFiles() {
        return this.files;
    }

    public void onExists(String filename) {
        this.files.add(filename);
    }

    @Override
    public String getTableStore() {
        this.update();
        return this.tableStore;
    }

    @Override
    public String getLastHeader() {
        this.update();
        return this.lastHeader;
    }

    private void update() {
        long now = System.currentTimeMillis();
        if (this.lastUpdate + 5000L > now) {
            return;
        }
        this.lastUpdate = now;
        Path path = Paths.get(this.basePath, this.relativePath);
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)path.toFile()).readOnly(true).build();){
            TableStore ts = queue.metaStore();
            this.tableStore = ts.shortDump();
            this.lastHeader = queue.dumpLastHeader();
        }
    }
}

