/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class CheckHalfWrittenMsgNotSeenByTailerTest {
    @Test
    public void checkTailerOnlyReadsTwoMessageOneProcess() throws InterruptedException {
        Assume.assumeTrue((!OS.isWindows() ? 1 : 0) != 0);
        File queueDirectory = DirectoryUtils.tempDir("halfWritten");
        HalfWriteAMessage.writeIncompleteMessage(queueDirectory.toString(), false);
        for (int i = 0; i < 3; ++i) {
            System.gc();
            Jvm.pause((long)50L);
        }
        try (ChronicleQueue single = ChronicleQueue.single((String)queueDirectory.getPath());
             ExcerptTailer tailer = single.createTailer();){
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"hello world 1", (Object)dc.wire().read("key1").text());
                Assert.assertEquals((Object)"hello world 2", (Object)dc.wire().read("key2").text());
            }
            dc = tailer.readingDocument();
            var7_12 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"hello world 3", (Object)dc.wire().read("key1").text());
                Assert.assertEquals((Object)"hello world 4", (Object)dc.wire().read("key2").text());
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var7_12 = null;
            try {
                boolean present = dc.isPresent();
                if (present) {
                    System.out.println(dc.wire().bytes().toHexString());
                    String key = (String)dc.wire().readEvent(String.class);
                    String value = dc.wire().getValueIn().text();
                    Assert.fail((String)("key: " + key + ", value: " + value));
                }
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var7_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var7_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void checkTailerOnlyReadsTwoMessageTwoProcesses() throws IOException, InterruptedException {
        Assume.assumeTrue((!OS.isWindows() ? 1 : 0) != 0);
        File queueDirectory = DirectoryUtils.tempDir("halfWritten");
        String command = String.format("mvn compile exec:java -Dexec.classpathScope=test -Dexec.mainClass=%s -Dexec.args=\"%s\"", HalfWriteAMessage.class.getName(), queueDirectory.getAbsoluteFile());
        CheckHalfWrittenMsgNotSeenByTailerTest.runCommand(command);
        try (ChronicleQueue single = ChronicleQueue.single((String)queueDirectory.getPath());
             ExcerptTailer tailer = single.createTailer();){
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"hello world 1", (Object)dc.wire().read("key1").text());
                Assert.assertEquals((Object)"hello world 2", (Object)dc.wire().read("key2").text());
            }
            dc = tailer.readingDocument();
            var8_12 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"hello world 3", (Object)dc.wire().read("key1").text());
                Assert.assertEquals((Object)"hello world 4", (Object)dc.wire().read("key2").text());
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = tailer.readingDocument();
            var8_12 = null;
            try {
                boolean present = dc.isPresent();
                if (present) {
                    Jvm.error().on(this.getClass(), "Found an excerpt " + dc.wire().bytes().toHexString());
                    String key = (String)dc.wire().readEvent(String.class);
                    String value = dc.wire().getValueIn().text();
                    Assert.fail((String)("key: " + key + ", value: " + value));
                }
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    private static void runCommand(String command) throws IOException, InterruptedException {
        String s;
        Process p = Runtime.getRuntime().exec(command);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        boolean buildFailure = false;
        while ((s = stdInput.readLine()) != null) {
            System.out.println(s);
            if (s.contains("BUILD FAILURE")) {
                buildFailure = true;
            }
            if (!"== FINISHED WRITING DATA ==".equals(s)) continue;
            return;
        }
        System.out.println("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            System.out.println(s);
        }
        p.waitFor();
        Assume.assumeFalse((boolean)buildFailure);
    }

    static {
        HalfWriteAMessage.class.getName();
    }

    public static class HalfWriteAMessage {
        public static void main(String[] args) throws InterruptedException {
            HalfWriteAMessage.writeIncompleteMessage(args[0], true);
        }

        private static void writeIncompleteMessage(String arg, boolean exit) throws InterruptedException {
            System.out.println("half writing a message to " + arg);
            ChronicleQueue single = ChronicleQueue.single((String)arg);
            ExcerptAppender excerptAppender = single.acquireAppender();
            try (DocumentContext dc = excerptAppender.writingDocument();){
                dc.wire().write((CharSequence)"key1").text("hello world 1");
                dc.wire().write((CharSequence)"key2").text("hello world 2");
            }
            dc = excerptAppender.writingDocument();
            var5_5 = null;
            try {
                dc.wire().write((CharSequence)"key1").text("hello world 3");
                dc.wire().write((CharSequence)"key2").text("hello world 4");
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var5_5 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            dc = excerptAppender.writingDocument();
            dc.wire().write((CharSequence)"key1").text("hello world 5");
            Thread.sleep(1L);
            System.out.println("== FINISHED WRITING DATA ==");
            if (exit) {
                System.exit(-1);
            }
            dc.wire().write((CharSequence)"key2").text("hello world 6");
        }
    }
}

