/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.main.DumpMain;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestMethodWriterWithThreads
extends ChronicleQueueTestBase {
    private static final int AMEND = 1;
    private static final int CREATE = 2;
    @Rule
    public final TestName testName = new TestName();
    private ThreadLocal<Amend> amendTL = ThreadLocal.withInitial(Amend::new);
    private ThreadLocal<Create> createTL = ThreadLocal.withInitial(Create::new);
    private I methodWriter;
    private AtomicBoolean fail = new AtomicBoolean();
    private boolean doubleBuffer;

    public TestMethodWriterWithThreads(boolean doubleBuffer) {
        this.doubleBuffer = doubleBuffer;
    }

    @Parameterized.Parameters(name="doubleBuffer={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="https://github.com/OpenHFT/Chronicle-Queue/issues/799")
    public void test() throws FileNotFoundException {
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue q = this.builder(tmpDir, WireType.BINARY).rollCycle((RollCycle)RollCycles.HOURLY).doubleBuffer(this.doubleBuffer).build();){
            this.methodWriter = (I)q.methodWriter(I.class, new Class[0]);
            IntStream.range(0, 1000).parallel().forEach(arg_0 -> this.lambda$test$0((ChronicleQueue)q, arg_0));
        }
        finally {
            if (this.fail.get()) {
                DumpMain.dump((String)tmpDir.getAbsolutePath());
            }
        }
    }

    @NotNull
    private I newReader() {
        return new I(){

            @Override
            public void amend(Amend amend) {
                if (amend.type != 1) {
                    TestMethodWriterWithThreads.this.fail.set(true);
                    TestCase.fail((String)("amend type=" + amend.type));
                }
            }

            @Override
            public void create(Create create) {
                if (create.type != 2) {
                    TestMethodWriterWithThreads.this.fail.set(true);
                    TestCase.fail((String)("create type=" + create.type));
                }
            }
        };
    }

    private void amends() {
        this.methodWriter.amend(this.amendTL.get().type(1));
    }

    private void creates() {
        this.methodWriter.create(this.createTL.get().type(2));
    }

    @NotNull
    protected SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)wireType).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$test$0(ChronicleQueue q, int i) {
        ExcerptTailer tailer = q.createTailer();
        try {
            this.creates();
            this.amends();
            MethodReader methodReader = tailer.methodReader(new Object[]{this.newReader()});
            int j = 0;
            while (j < 2 && !this.fail.get()) {
                if (!methodReader.readOne()) continue;
                ++j;
            }
        }
        catch (Throwable throwable) {
            Closeable.closeQuietly((Object[])new Object[]{q.acquireAppender(), tailer});
            throw throwable;
        }
        Closeable.closeQuietly((Object[])new Object[]{q.acquireAppender(), tailer});
        if (this.fail.get()) {
            TestCase.fail();
        }
    }

    static class Create
    extends SelfDescribingMarshallable {
        int type;

        Create() {
        }

        Create type(int type) {
            this.type = type;
            return this;
        }
    }

    static class Amend
    extends SelfDescribingMarshallable {
        int type;

        Amend() {
        }

        Amend type(int type) {
            this.type = type;
            return this;
        }
    }

    static interface I {
        public void amend(Amend var1);

        public void create(Create var1);
    }
}

