/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.TestKey;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SingleChronicleQueueCloseTest
extends ChronicleQueueTestBase {
    @Test
    public void testTailAfterClose() {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder((File)this.getTmpDir(), (WireType)WireType.BINARY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument(w -> w.write((WireKey)TestKey.test).int32(1));
            queue.close();
            try {
                appender.writeDocument(w -> w.write((WireKey)TestKey.test).int32(2));
                Assert.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Test
    public void reacquireAppenderAfterClose() {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder((File)this.getTmpDir(), (WireType)WireType.BINARY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"hello1");
            appender.close();
            ExcerptAppender appender2 = queue.acquireAppender();
            appender2.writeText((CharSequence)"hello2");
            appender.close();
            ExcerptAppender appender3 = queue.acquireAppender();
            appender2.writeText((CharSequence)"hello3");
            ExcerptAppender appender4 = queue.acquireAppender();
            appender2.writeText((CharSequence)"hello4");
            Assert.assertSame((Object)appender3, (Object)appender4);
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertEquals((Object)"hello1", (Object)tailer.readText());
            Assert.assertEquals((Object)"hello2", (Object)tailer.readText());
            Assert.assertEquals((Object)"hello3", (Object)tailer.readText());
            Assert.assertEquals((Object)"hello4", (Object)tailer.readText());
        }
    }

    @Ignore(value="https://github.com/OpenHFT/Chronicle-Queue/issues/788")
    @Test
    public void reacquireTailerAfterClose() {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.builder((File)this.getTmpDir(), (WireType)WireType.BINARY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"hello1");
            StoreTailer tailer = queue.acquireTailer();
            Assert.assertEquals((Object)"hello1", (Object)tailer.readText());
            tailer.close();
            StoreTailer tailer2 = queue.acquireTailer();
            Assert.assertEquals((Object)"hello1", (Object)tailer2.readText());
        }
    }
}

