/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import org.junit.Assert;
import org.junit.Test;

public class QueueLockTest
extends ChronicleQueueTestBase {
    @Test
    public void testTimeout() throws InterruptedException {
        this.check(true);
    }

    @Test
    public void testRecover() throws InterruptedException {
        this.check(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(boolean shouldThrowException) throws InterruptedException {
        try {
            System.setProperty("queue.dont.recover.lock.timeout", Boolean.toString(shouldThrowException));
            long timeoutMs = 5000L;
            File queueDir = DirectoryUtils.tempDir("check");
            try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)queueDir).timeoutMS(5000L).build();){
                queue.acquireAppender().writingDocument();
                CountDownLatch started = new CountDownLatch(1);
                CountDownLatch finished = new CountDownLatch(1);
                AtomicBoolean recoveredAndAcquiredTheLock = new AtomicBoolean();
                AtomicBoolean threwException = new AtomicBoolean();
                Thread otherWriter = new Thread(() -> QueueLockTest.lambda$check$0(started, (RollingChronicleQueue)queue, recoveredAndAcquiredTheLock, threwException, finished));
                otherWriter.start();
                started.await(1L, TimeUnit.SECONDS);
                long startTime = System.currentTimeMillis();
                finished.await(10L, TimeUnit.SECONDS);
                long endTime = System.currentTimeMillis();
                Assert.assertTrue((String)"timeout", (endTime >= startTime + 5000L ? 1 : 0) != 0);
                Assert.assertEquals((Object)shouldThrowException, (Object)threwException.get());
                Assert.assertEquals((Object)shouldThrowException, (Object)(!recoveredAndAcquiredTheLock.get() ? 1 : 0));
            }
        }
        finally {
            System.clearProperty("queue.dont.recover.lock.timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$check$0(CountDownLatch started, RollingChronicleQueue queue, AtomicBoolean recoveredAndAcquiredTheLock, AtomicBoolean threwException, CountDownLatch finished) {
        started.countDown();
        try (DocumentContext ignored = queue.acquireAppender().writingDocument();){
            recoveredAndAcquiredTheLock.set(true);
        }
        catch (UnrecoverableTimeoutException e) {
            threwException.set(true);
        }
        finally {
            finished.countDown();
        }
    }
}

