/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.threads.Threads;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QueueFileShrinkManager {

    public static final String THREAD_NAME = "queue~file~shrink~daemon";
    public static final boolean RUN_SYNCHRONOUSLY = Jvm.getBoolean("chronicle.queue.synchronousFileShrinking");
    public static final boolean DISABLE_QUEUE_FILE_SHRINKING = OS.isWindows() || Jvm.getBoolean("chronicle.queue.disableFileShrinking");
    private static final Logger LOG = LoggerFactory.getLogger(QueueFileShrinkManager.class);
    private static final ScheduledExecutorService EXECUTOR = Threads.acquireScheduledExecutorService("queue~file~shrink~daemon", true);
    private static final long DELAY_S = 10L;

    public static void scheduleShrinking(@NotNull File queueFile, long writePos) {
        if (DISABLE_QUEUE_FILE_SHRINKING) {
            return;
        }
        if (RUN_SYNCHRONOUSLY) {
            QueueFileShrinkManager.task(queueFile, writePos);
        } else {
            EXECUTOR.schedule(() -> QueueFileShrinkManager.task(queueFile, writePos), 10L, TimeUnit.SECONDS);
        }
    }

    private static void task(@NotNull File queueFile, long writePos) {
        int i;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shrinking {} to {}", (Object)queueFile, (Object)writePos);
        }
        int timeout = 50;
        int n = i = OS.isWindows() ? 1 : 3;
        while (i >= 0) {
            if (!queueFile.exists()) {
                LOG.warn("Failed to shrink file as it exists no longer, file=" + queueFile);
                return;
            }
            try (RandomAccessFile raf = new RandomAccessFile(queueFile, "rw");){
                raf.setLength(writePos);
                break;
            }
            catch (IOException ex) {
                if (ex.getMessage().contains("The requested operation cannot be performed on a file with a user-mapped section open")) {
                    LOG.debug("Failed to shrinking {} to {}, {}", queueFile, writePos, i == 0 ? "giving up" : "retrying");
                    Jvm.pause(timeout);
                    timeout *= 2;
                } else {
                    LOG.warn("Failed to shrink file " + queueFile, ex);
                    break;
                }
                --i;
            }
        }
    }
}

