/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.jlbh.JLBH;
import net.openhft.chronicle.core.jlbh.JLBHOptions;
import net.openhft.chronicle.core.jlbh.JLBHTask;
import net.openhft.chronicle.core.util.NanoSampler;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.MilliTimestampLongConverter;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import org.eclipse.jetty.io.RuntimeIOException;

public class MethodReaderBenchmark
implements JLBHTask {
    private ChronicleQueue queue;
    private ExcerptTailer tailer;
    private ExcerptAppender appender;
    private NanoSampler noArgsCallSampler;
    private NanoSampler oneIntCallSampler;
    private NanoSampler oneLongCallSampler;
    private NanoSampler smallDtoCallSampler;
    private NanoSampler stringAndSmallDtoCallSampler;
    private NanoSampler bigDtoCallSampler;
    private NanoSampler stringAndBigDtoCallSampler;
    private Object writer;
    private ExecutionReportDTO nextExecutionReport;
    private OrderDTO nextOrder;
    private MethodReader reader;
    private volatile boolean stopped = false;

    public static void main(String[] args) {
        String benchmarkIterationsString = System.getProperty("benchmarkIterations");
        int iterations = benchmarkIterationsString == null ? 100000 : Integer.parseInt(benchmarkIterationsString);
        System.out.println("Iterations: " + iterations);
        String benchmarkThroughputString = System.getProperty("benchmarkThroughput");
        int throughput = benchmarkThroughputString == null ? 20000 : Integer.parseInt(benchmarkThroughputString);
        System.out.println("Throughput: " + throughput);
        JLBHOptions lth = new JLBHOptions().warmUpIterations(100000).iterations(iterations).throughput(throughput).recordOSJitter(false).accountForCoordinatedOmmission(true).skipFirstRun(true).runs(5).jlbhTask((JLBHTask)new MethodReaderBenchmark());
        new JLBH(lth).start();
    }

    public void init(final JLBH jlbh) {
        String benchmarkQueuePath = System.getProperty("benchmarkQueuePath");
        if (benchmarkQueuePath != null) {
            System.out.println("Creating queue in dir: " + benchmarkQueuePath);
            IOTools.deleteDirWithFiles((String)benchmarkQueuePath, (int)10);
            this.queue = ChronicleQueue.single((String)benchmarkQueuePath);
        } else {
            System.out.println("Creating queue in temp dir");
            try {
                this.queue = ChronicleQueue.single((String)Files.createTempDirectory("temp", new FileAttribute[0]).toString());
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
        this.appender = this.queue.acquireAppender();
        this.writer = this.appender.methodWriter(AnInterface.class, new Class[0]);
        this.nextExecutionReport = new ExecutionReportDTO(ThreadLocalRandom.current());
        this.nextOrder = new OrderDTO(ThreadLocalRandom.current());
        new Thread(new Runnable(){

            @Override
            public void run() {
                AffinityLock.acquireCore();
                MethodReaderBenchmark.this.tailer = MethodReaderBenchmark.this.queue.createTailer();
                MethodReaderBenchmark.this.noArgsCallSampler = jlbh.addProbe("No args call");
                MethodReaderBenchmark.this.oneIntCallSampler = jlbh.addProbe("One int call");
                MethodReaderBenchmark.this.oneLongCallSampler = jlbh.addProbe("One long call");
                MethodReaderBenchmark.this.smallDtoCallSampler = jlbh.addProbe("Small DTO call");
                MethodReaderBenchmark.this.stringAndSmallDtoCallSampler = jlbh.addProbe("String and small DTO call");
                MethodReaderBenchmark.this.bigDtoCallSampler = jlbh.addProbe("Big DTO call");
                MethodReaderBenchmark.this.stringAndBigDtoCallSampler = jlbh.addProbe("String and big DTO call");
                AnInterfaceSamplingImpl samplingImpl = new AnInterfaceSamplingImpl();
                MethodReaderBenchmark.this.reader = MethodReaderBenchmark.this.tailer.methodReader(new Object[]{samplingImpl});
                while (!MethodReaderBenchmark.this.stopped) {
                    String startNsString;
                    if (!MethodReaderBenchmark.this.reader.readOne()) continue;
                    while ((startNsString = MethodReaderBenchmark.this.tailer.readText()) == null) {
                    }
                    long startNs = Long.parseLong(startNsString);
                    samplingImpl.doSample(startNs);
                    jlbh.sample(System.nanoTime() - startNs);
                }
            }
        }).start();
    }

    public void run(long startTimeNS) {
        AnInterface w = (AnInterface)this.writer;
        ThreadLocalRandom r = ThreadLocalRandom.current();
        int nextMethod = r.nextInt(7);
        switch (nextMethod) {
            case 0: {
                w.noArgsCall();
                break;
            }
            case 1: {
                w.oneIntCall(r.nextInt());
                break;
            }
            case 2: {
                w.oneLongCall(r.nextLong());
                break;
            }
            case 3: {
                w.smallDtoCall(this.nextOrder);
                this.nextOrder = new OrderDTO(r);
                break;
            }
            case 4: {
                w.stringAndSmallDtoCall(MethodReaderBenchmark.nextSymbol(r), this.nextOrder);
                this.nextOrder = new OrderDTO(r);
                break;
            }
            case 5: {
                w.bigDtoCall(this.nextExecutionReport);
                this.nextExecutionReport = new ExecutionReportDTO(r);
                break;
            }
            case 6: {
                w.stringAndBigDtoCall(MethodReaderBenchmark.nextSymbol(r), this.nextExecutionReport);
                this.nextExecutionReport = new ExecutionReportDTO(r);
                break;
            }
            default: {
                throw new IllegalStateException("unknown method");
            }
        }
        this.appender.writeText((CharSequence)String.valueOf(startTimeNS));
    }

    public void complete() {
        this.stopped = true;
        this.queue.close();
    }

    private static String nextSymbol(Random r) {
        StringBuilder sb = new StringBuilder();
        int length = r.nextInt(6) + 2;
        for (int i = 0; i < length + 2; ++i) {
            sb.append(65 + r.nextInt(25));
        }
        return sb.toString();
    }

    private static long nextTimestampMillis(Random r) {
        return System.currentTimeMillis() + (long)r.nextInt(1000000) - 500000L;
    }

    static class ExecutionReportDTO
    extends SelfDescribingMarshallable {
        private String orderID;
        private Bytes clOrdID;
        private String execID;
        private char execTransType;
        private char execType;
        private char ordStatus;
        private Bytes account;
        private char settlmntTyp;
        private Bytes securityID;
        private String idSource;
        private char side;
        private double orderQty;
        private char ordType;
        private double price;
        private String currency;
        private char timeInForce;
        private double lastShares;
        private double lastPx;
        private String lastMkt;
        private double leavesQty;
        private double cumQty;
        private double avgPx;
        private String tradeDate;
        @LongConversion(value=MilliTimestampLongConverter.class)
        private long transactTime;
        private String settlCurrency;
        private char handlInst;
        private long createdNS;

        public ExecutionReportDTO(Random r) {
            this.orderID = MethodReaderBenchmark.nextSymbol(r);
            this.clOrdID = Bytes.from((String)MethodReaderBenchmark.nextSymbol(r));
            this.execID = MethodReaderBenchmark.nextSymbol(r);
            this.execTransType = (char)r.nextInt();
            this.execType = (char)r.nextInt();
            this.ordStatus = (char)r.nextInt();
            this.account = Bytes.from((String)MethodReaderBenchmark.nextSymbol(r));
            this.settlmntTyp = (char)r.nextInt();
            this.securityID = Bytes.from((String)MethodReaderBenchmark.nextSymbol(r));
            this.idSource = MethodReaderBenchmark.nextSymbol(r);
            this.side = (char)r.nextInt();
            this.orderQty = r.nextDouble();
            this.ordType = (char)r.nextInt();
            this.price = r.nextDouble();
            this.currency = MethodReaderBenchmark.nextSymbol(r);
            this.timeInForce = (char)r.nextInt();
            this.lastShares = r.nextDouble();
            this.lastPx = r.nextDouble();
            this.lastMkt = MethodReaderBenchmark.nextSymbol(r);
            this.leavesQty = r.nextDouble();
            this.cumQty = r.nextDouble();
            this.avgPx = r.nextDouble();
            this.tradeDate = MethodReaderBenchmark.nextSymbol(r);
            this.transactTime = MethodReaderBenchmark.nextTimestampMillis(r);
            this.settlCurrency = MethodReaderBenchmark.nextSymbol(r);
            this.handlInst = (char)r.nextInt();
            this.createdNS = MethodReaderBenchmark.nextTimestampMillis(r);
        }
    }

    static class OrderDTO
    extends SelfDescribingMarshallable {
        private char side;
        private char ordType;
        private String symbol;
        private long accountId;
        private double orderQty;
        private double price;
        private long createdTime;

        public OrderDTO(Random r) {
            this.side = (char)r.nextInt();
            this.ordType = (char)r.nextInt();
            this.symbol = MethodReaderBenchmark.nextSymbol(r);
            this.accountId = r.nextLong();
            this.orderQty = r.nextDouble();
            this.price = r.nextDouble();
            this.createdTime = MethodReaderBenchmark.nextTimestampMillis(r);
        }
    }

    class AnInterfaceSamplingImpl
    implements AnInterface {
        private long nanos;
        private NanoSampler sampler;

        AnInterfaceSamplingImpl() {
        }

        @Override
        public void noArgsCall() {
            this.nanos = System.nanoTime();
            this.sampler = MethodReaderBenchmark.this.noArgsCallSampler;
        }

        @Override
        public void oneIntCall(int x) {
            this.nanos = System.nanoTime();
            this.sampler = MethodReaderBenchmark.this.oneIntCallSampler;
        }

        @Override
        public void oneLongCall(long x) {
            this.nanos = System.nanoTime();
            this.sampler = MethodReaderBenchmark.this.oneLongCallSampler;
        }

        @Override
        public void smallDtoCall(OrderDTO orderDTO) {
            this.nanos = System.nanoTime();
            this.sampler = MethodReaderBenchmark.this.smallDtoCallSampler;
        }

        @Override
        public void stringAndSmallDtoCall(String s, OrderDTO orderDTO) {
            this.nanos = System.nanoTime();
            this.sampler = MethodReaderBenchmark.this.stringAndSmallDtoCallSampler;
        }

        @Override
        public void bigDtoCall(ExecutionReportDTO executionReportDTO) {
            this.nanos = System.nanoTime();
            this.sampler = MethodReaderBenchmark.this.bigDtoCallSampler;
        }

        @Override
        public void stringAndBigDtoCall(String s, ExecutionReportDTO executionReportDTO) {
            this.nanos = System.nanoTime();
            this.sampler = MethodReaderBenchmark.this.stringAndBigDtoCallSampler;
        }

        public void doSample(long startNs) {
            this.sampler.sampleNanos(this.nanos - startNs);
        }
    }

    static interface AnInterface {
        public void noArgsCall();

        public void oneIntCall(int var1);

        public void oneLongCall(long var1);

        public void smallDtoCall(OrderDTO var1);

        public void stringAndSmallDtoCall(String var1, OrderDTO var2);

        public void bigDtoCall(ExecutionReportDTO var1);

        public void stringAndBigDtoCall(String var1, ExecutionReportDTO var2);
    }
}

