/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.concurrent.ThreadLocalRandom;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class ToEndPaddingTest
extends ChronicleQueueTestBase {
    @Test
    public void toEndWorksWithDifferentlyPaddedMessages() {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)this.getTmpDir()).build();){
            String text2;
            ExcerptAppender appender = queue.acquireAppender();
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext documentContext = appender.acquireWritingDocument(false);){
                documentContext.wire().write((CharSequence)"start").text("start");
            }
            documentContext = tailer.readingDocument(false);
            var6_10 = null;
            try {
                Assert.assertTrue((boolean)documentContext.isPresent());
                text2 = documentContext.wire().read().text();
                Assert.assertEquals((Object)"start", (Object)text2);
            }
            catch (Throwable text2) {
                var6_10 = text2;
                throw text2;
            }
            finally {
                if (documentContext != null) {
                    if (var6_10 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable text2) {
                            var6_10.addSuppressed(text2);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
            for (int i = 0; i < 20; ++i) {
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j <= i; ++j) {
                    sb.append((char)(65 + ThreadLocalRandom.current().nextInt(26)));
                }
                try (DocumentContext documentContext = appender.acquireWritingDocument(true);){
                    documentContext.wire().write((CharSequence)("metakey" + i)).text((CharSequence)sb);
                    continue;
                }
            }
            tailer.toEnd();
            documentContext = appender.acquireWritingDocument(false);
            var6_10 = null;
            try {
                documentContext.wire().write((CharSequence)"key").text("value");
            }
            catch (Throwable documentContext) {
                var6_10 = documentContext;
                throw documentContext;
            }
            finally {
                if (documentContext != null) {
                    if (var6_10 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable documentContext) {
                            var6_10.addSuppressed(documentContext);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
            documentContext = tailer.readingDocument(false);
            var6_10 = null;
            try {
                Assert.assertTrue((boolean)documentContext.isPresent());
                text2 = documentContext.wire().read().text();
                Assert.assertEquals((Object)"value", (Object)text2);
            }
            catch (Throwable throwable) {
                var6_10 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext != null) {
                    if (var6_10 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var6_10.addSuppressed(throwable);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
        }
    }
}

