/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.QueueTestCommon;
import org.jetbrains.annotations.NotNull;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronicleQueueTestBase
extends QueueTestCommon {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ChronicleQueueTestBase.class);
    private static final boolean TRACE_TEST_EXECUTION = Jvm.getBoolean((String)"queue.traceTestExecution");
    private List<File> tmpDirs = new ArrayList<File>();
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final ErrorCollector errorCollector = new ErrorCollector();
    @Rule
    @NotNull
    public TestRule watcher = new TestWatcher(){

        protected void starting(@NotNull Description description) {
            if (TRACE_TEST_EXECUTION) {
                LOGGER.info("Starting test: {}.{}", (Object)description.getClassName(), (Object)description.getMethodName());
            }
        }
    };
    static AtomicLong counter;

    @BeforeClass
    public static void synchronousFileTruncating() {
        System.setProperty("chronicle.queue.synchronousFileShrinking", "true");
    }

    @NotNull
    protected File getTmpDir() {
        String methodName = this.testName.getMethodName();
        String name = methodName == null ? "unknown" : methodName;
        File tmpDir = DirectoryUtils.tempDir(name + "-" + counter.incrementAndGet());
        this.tmpDirs.add(tmpDir);
        return tmpDir;
    }

    @Override
    public void afterChecks() {
        super.afterChecks();
        this.tmpDirs.forEach(file -> {
            if (file.exists() && !IOTools.deleteDirWithFiles((File)file)) {
                LOGGER.error("Could not delete tmp dir {}. Remaining {}", file, (Object)file.list());
            }
        });
    }

    static {
        System.setProperty("queue.check.index", "true");
        counter = new AtomicLong();
    }
}

