/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class WireObjectInput
implements ObjectInput {
    private final WireIn wire;

    WireObjectInput(WireIn wire) {
        this.wire = wire;
    }

    @Override
    @Nullable
    public Object readObject() throws ClassNotFoundException, IOException {
        return this.wire.getValueIn().object();
    }

    @Override
    public int read() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            return -1;
        }
        return this.wire.getValueIn().int8() & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        long remaining = this.wire.bytes().readRemaining();
        if (remaining <= 0L) {
            throw new EOFException();
        }
        if ((long)len > remaining) {
            len = (int)remaining;
        }
        Bytes<byte[]> bytes = Bytes.wrapForWrite(b);
        bytes.writePosition(off);
        bytes.writeLimit(off + len);
        this.wire.getValueIn().bytes(bytes);
        return (int)(bytes.writePosition() - (long)off);
    }

    @Override
    public long skip(long n) throws IOException {
        @NotNull Bytes<?> bytes = this.wire.bytes();
        long maxRewind = bytes.start() - bytes.readPosition();
        long len = Math.max(maxRewind, Math.min(bytes.readRemaining(), n));
        bytes.readSkip(len);
        return len;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min(Integer.MAX_VALUE, this.wire.bytes().readRemaining());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return this.wire.getValueIn().bool();
    }

    @Override
    public byte readByte() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return this.wire.getValueIn().int8();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return this.wire.getValueIn().int8() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return this.wire.getValueIn().int16();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return this.wire.getValueIn().uint16();
    }

    @Override
    public char readChar() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return (char)this.wire.getValueIn().int16();
    }

    @Override
    public int readInt() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return this.wire.getValueIn().int32();
    }

    @Override
    public long readLong() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return this.wire.getValueIn().int64();
    }

    @Override
    public float readFloat() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return this.wire.getValueIn().float32();
    }

    @Override
    public double readDouble() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return this.wire.getValueIn().float64();
    }

    @Override
    @NotNull
    public String readLine() throws IOException {
        return this.readUTF();
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        if (this.wire.bytes().readRemaining() <= 0L) {
            throw new EOFException();
        }
        return this.wire.getValueIn().text();
    }
}

