/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.util.Compressions;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Compression {
    public static <T> void compress(@NotNull CharSequence cs, @NotNull Bytes uncompressed, @NotNull Bytes compressed) {
        switch (cs.charAt(0)) {
            case 'l': {
                if (!StringUtils.isEqual("lzw", cs)) break;
                Compressions.LZW.compress(uncompressed, compressed);
                return;
            }
            case 'g': {
                if (!StringUtils.isEqual("gzip", cs)) break;
                Compressions.GZIP.compress(uncompressed, compressed);
                return;
            }
        }
        Compressions.Binary.compress(uncompressed, compressed);
    }

    public static void uncompress(@NotNull CharSequence cs, @NotNull BytesIn from, @NotNull BytesOut to) throws IORuntimeException {
        switch (cs.charAt(0)) {
            case '!': 
            case 'b': {
                if (!StringUtils.isEqual("binary", cs) && !StringUtils.isEqual("!binary", cs)) break;
                Compressions.Binary.uncompress(from, to);
                return;
            }
            case 'l': {
                if (!StringUtils.isEqual("lzw", cs)) break;
                Compressions.LZW.uncompress(from, to);
                return;
            }
            case 'g': {
                if (!StringUtils.isEqual("gzip", cs)) break;
                Compressions.GZIP.uncompress(from, to);
                return;
            }
            default: {
                throw new IllegalArgumentException("Unsupported compression " + cs);
            }
        }
    }

    @Nullable
    public static <T> byte[] uncompress(@NotNull CharSequence cs, T t, @NotNull ThrowingFunction<T, byte[], IORuntimeException> bytes) throws IORuntimeException {
        switch (cs.charAt(0)) {
            case '!': 
            case 'b': {
                if (!StringUtils.isEqual("binary", cs) && !StringUtils.isEqual("!binary", cs)) break;
                return Compressions.Binary.uncompress(bytes.apply(t));
            }
            case 'l': {
                if (!StringUtils.isEqual("lzw", cs)) break;
                return Compressions.LZW.uncompress(bytes.apply(t));
            }
            case 'g': {
                if (!StringUtils.isEqual("gzip", cs)) break;
                return Compressions.GZIP.uncompress(bytes.apply(t));
            }
            default: {
                return null;
            }
        }
        return null;
    }

    default public byte[] compress(@NotNull byte[] bytes) {
        @NotNull ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStream output = this.compressingStream(baos);){
            output.write(bytes);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return baos.toByteArray();
    }

    default public void compress(@NotNull BytesIn from, @NotNull BytesOut to) {
        try (OutputStream output = this.compressingStream(to.outputStream());){
            from.copyTo(output);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public byte[] uncompress(@NotNull byte[] bytes) throws IORuntimeException {
        @NotNull ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream input = this.decompressingStream(new ByteArrayInputStream(bytes));){
            int len;
            @NotNull byte[] buf = new byte[512];
            while ((len = input.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return baos.toByteArray();
    }

    default public void uncompress(@NotNull BytesIn from, @NotNull BytesOut to) throws IORuntimeException {
        try (InputStream input = this.decompressingStream(from.inputStream());){
            to.copyFrom(input);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public InputStream decompressingStream(InputStream var1) throws IORuntimeException;

    public OutputStream compressingStream(OutputStream var1);

    default public boolean available() {
        return true;
    }
}

