/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class BackwardWithPretouchTest
extends ChronicleQueueTestBase {
    @Test
    public void testAppenderBackwardWithPretoucher() {
        this.test(1000);
    }

    @Test
    public void testAppenderBackwardWithPretoucherPause2Seconds() {
        this.test(2000);
    }

    @Test
    public void testAppenderBackwardWithPretoucherPause3Seconds() {
        this.test(3000);
    }

    private void test(int pause) {
        SetTimeProvider timeProvider = new SetTimeProvider();
        timeProvider.currentTimeMillis(System.currentTimeMillis());
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tmpDir).timeProvider((TimeProvider)timeProvider).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            ExcerptAppender excerptAppender = queue.acquireAppender();
            try (DocumentContext dc = excerptAppender.writingDocument();){
                dc.wire().write((CharSequence)"hello").text("world");
            }
            timeProvider.advanceMillis((long)pause);
            ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD);
            tailer.toEnd();
            int cycle = tailer.cycle();
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertEquals((Object)"world", (Object)dc.wire().read("hello").text());
            }
            excerptAppender.pretouch();
            tailer = queue.createTailer().direction(TailerDirection.BACKWARD);
            tailer.toEnd();
            Assert.assertEquals((long)cycle, (long)tailer.cycle());
            dc = tailer.readingDocument();
            var10_16 = null;
            try {
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertEquals((Object)"world", (Object)dc.wire().read("hello").text());
            }
            catch (Throwable throwable) {
                var10_16 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var10_16 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var10_16.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }
}

