/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.invariant.longs;

import java.util.Objects;
import java.util.function.LongPredicate;

public enum LongCondition implements LongPredicate
{
    POSITIVE("> 0", value -> value > 0L),
    NEGATIVE("< 0", value -> value < 0L),
    ZERO("== 0", value -> value == 0L),
    NON_POSITIVE("<= 0", value -> value <= 0L),
    NON_NEGATIVE(">= 0", value -> value >= 0L),
    NON_ZERO("!= 0", value -> value != 0L),
    BYTE_CONVERTIBLE(-128L, 127L),
    SHORT_CONVERTIBLE(-32768L, 32767L),
    EVEN_POWER_OF_TWO(" > 0 && bitcount == 1", value -> value > 0L && Long.bitCount(value) == 1);

    private final String operation;
    private final LongPredicate predicate;

    private LongCondition(String operation, LongPredicate predicate) {
        this.operation = Objects.requireNonNull(operation);
        this.predicate = Objects.requireNonNull(predicate);
    }

    private LongCondition(long fromInclusive, long toInclusive) {
        this.operation = "\u2208 [" + fromInclusive + ", " + toInclusive + "]";
        this.predicate = value -> value >= fromInclusive && value <= toInclusive;
    }

    @Override
    public boolean test(long value) {
        return this.predicate.test(value);
    }

    @Override
    public LongPredicate negate() {
        switch (this) {
            case POSITIVE: {
                return NON_POSITIVE;
            }
            case NEGATIVE: {
                return NON_NEGATIVE;
            }
            case ZERO: {
                return NON_ZERO;
            }
            case NON_POSITIVE: {
                return POSITIVE;
            }
            case NON_NEGATIVE: {
                return NEGATIVE;
            }
            case NON_ZERO: {
                return ZERO;
            }
        }
        return LongPredicate.super.negate();
    }

    public String toString() {
        return this.operation;
    }
}

