/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.NanoSampler;
import net.openhft.chronicle.jlbh.JLBH;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHTask;
import net.openhft.chronicle.jlbh.TeamCityHelper;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.WriteMarshallable;

public class QueueContendedWritesJLBHBenchmark
implements JLBHTask {
    public static final int ITERATIONS = 100000;
    private SingleChronicleQueue queue;
    private ExcerptTailer tailer;
    private JLBH jlbh;
    private NanoSampler concurrent;
    private NanoSampler concurrent2;
    private volatile boolean stopped = false;
    private AtomicInteger write = new AtomicInteger(0);
    private final Datum datum = new Datum();
    private final Datum datum2 = new Datum();
    private Thread writerThread1;
    private Thread writerThread2;
    long written = 0L;

    public static void main(String[] args) {
        JLBHOptions lth = new JLBHOptions().warmUpIterations(50000).iterations(100000).throughput(10000).recordOSJitter(false).accountForCoordinatedOmission(false).skipFirstRun(true).runs(3).jlbhTask((JLBHTask)new QueueContendedWritesJLBHBenchmark());
        new JLBH(lth).start();
    }

    public void init(JLBH jlbh) {
        IOTools.deleteDirWithFiles((String)"replica", (int)10);
        this.jlbh = jlbh;
        this.concurrent = jlbh.addProbe("Concurrent");
        this.concurrent2 = jlbh.addProbe("Concurrent2");
        this.queue = SingleChronicleQueueBuilder.single((String)"replica").rollCycle((RollCycle)RollCycles.LARGE_DAILY).doubleBuffer(false).build();
        this.tailer = this.queue.createTailer();
        this.tailer.toStart();
        this.writerThread1 = new Thread(() -> {
            AffinityLock.acquireCore();
            ExcerptAppender app = this.queue.acquireAppender();
            while (!this.stopped) {
                long start;
                if (this.write.get() <= 0) continue;
                this.write.decrementAndGet();
                this.datum2.ts = start = System.nanoTime();
                this.datum2.username = "" + start;
                try (DocumentContext dc = app.writingDocument();){
                    dc.wire().write((CharSequence)"datum").marshallable((WriteMarshallable)this.datum2);
                }
                this.concurrent2.sampleNanos(System.nanoTime() - start);
            }
            this.queue.close();
        });
        this.writerThread1.start();
        this.writerThread2 = new Thread(() -> {
            AffinityLock.acquireCore();
            ExcerptAppender app = this.queue.acquireAppender();
            while (!this.stopped) {
                long start;
                if (this.write.get() <= 0) continue;
                this.write.decrementAndGet();
                this.datum.ts = start = System.nanoTime();
                this.datum.username = "" + start;
                try (DocumentContext dc = app.writingDocument();){
                    dc.wire().write((CharSequence)"datum").marshallable((WriteMarshallable)this.datum);
                }
                this.concurrent.sampleNanos(System.nanoTime() - start);
            }
            this.queue.close();
        });
        this.writerThread2.start();
    }

    public void run(long startTimeNS) {
        this.write.set(2);
        int read = 0;
        while (read < 2) {
            DocumentContext dc = this.tailer.readingDocument();
            Throwable throwable = null;
            try {
                if (dc.wire() == null || !dc.wire().read("datum").marshallable((ReadMarshallable)this.datum)) continue;
                ++read;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
            }
        }
        this.jlbh.sampleNanos(System.nanoTime() - startTimeNS);
        ++this.written;
        if (this.written % 10000L == 0L) {
            System.err.println("Written: " + this.written);
        }
    }

    public void complete() {
        this.stopped = true;
        this.join(this.writerThread1);
        this.join(this.writerThread2);
        this.queue.close();
        TeamCityHelper.teamCityStatsLastRun((String)this.getClass().getSimpleName(), (JLBH)this.jlbh, (int)100000, (PrintStream)System.out);
    }

    private void join(Thread t) {
        try {
            t.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static class Datum
    extends SelfDescribingMarshallable {
        public long ts = 0L;
        public String username;
        public byte[] filler0 = new byte[128];
        public byte[] filler1 = new byte[128];
        public byte[] filler2 = new byte[128];
        public byte[] filler3 = new byte[128];
        public byte[] filler4 = new byte[128];
        public byte[] filler5 = new byte[128];
        public byte[] filler6 = new byte[128];
        public byte[] filler7 = new byte[128];
        public byte[] filler8 = new byte[128];
        public byte[] filler9 = new byte[128];
        public byte[] filler10 = new byte[128];
        public byte[] filler11 = new byte[128];
        public byte[] filler12 = new byte[128];
        public byte[] filler13 = new byte[128];
        public byte[] filler14 = new byte[128];
        public byte[] filler15 = new byte[128];
        public byte[] filler16 = new byte[128];
        public byte[] filler17 = new byte[128];
        public byte[] filler18 = new byte[128];
        public byte[] filler19 = new byte[128];
        public byte[] filler20 = new byte[128];
        public byte[] filler21 = new byte[128];
        public byte[] filler22 = new byte[128];
        public byte[] filler23 = new byte[128];
        public byte[] filler24 = new byte[128];
        public byte[] filler25 = new byte[128];
        public byte[] filler26 = new byte[128];
        public byte[] filler27 = new byte[128];
        public byte[] filler28 = new byte[128];
        public byte[] filler29 = new byte[128];
        public byte[] filler30 = new byte[128];
        public byte[] filler31 = new byte[128];
        public byte[] filler32 = new byte[128];
        public byte[] filler33 = new byte[128];
        public byte[] filler34 = new byte[128];
        public byte[] filler35 = new byte[128];
        public byte[] filler36 = new byte[128];
        public byte[] filler37 = new byte[128];
        public byte[] filler38 = new byte[128];
        public byte[] filler39 = new byte[128];

        private Datum() {
        }
    }
}

