/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestDeleteQueueFile
extends ChronicleQueueTestBase {
    private final Path tempQueueDir = this.getTmpDir().toPath();

    @Test
    public void testQueueFileDeletionWhileInUse() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        SetTimeProvider timeProvider = new SetTimeProvider();
        QueueStoreFileListener listener = new QueueStoreFileListener();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((Path)this.tempQueueDir.resolve("unitTestQueue")).timeProvider((TimeProvider)timeProvider).storeFileListener((StoreFileListener)listener).build();){
            ExcerptAppender appender = queue.acquireAppender();
            Assert.assertEquals((long)Long.MAX_VALUE, (long)queue.firstIndex());
            this.writeTextAndReturnFirstIndex(appender, 10, "test");
            timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(1L));
            long firstIndexOfSecondCycle = this.writeTextAndReturnFirstIndex(appender, 5, "test2");
            BackgroundResourceReleaser.releasePendingResources();
            String firstFile = this.getOnlyItem(listener.getReleasedFiles());
            String secondFile = this.getOnlyItem(listener.getAcquiredButNotReleasedFiles());
            Assert.assertNotEquals((Object)firstFile, (Object)secondFile);
            long indexAfter15Records = appender.lastIndexAppended();
            ExcerptTailer excerptTailer = queue.createTailer();
            this.readText(excerptTailer, 10, "test");
            this.readText(excerptTailer, 5, "test2");
            Assert.assertEquals((long)indexAfter15Records, (long)(excerptTailer.index() - 1L));
            Files.delete(Paths.get(firstFile, new String[0]));
            queue.refreshDirectoryListing();
            Assert.assertEquals((long)queue.firstIndex(), (long)firstIndexOfSecondCycle);
            ExcerptTailer excerptTailer2 = queue.createTailer();
            Assert.assertEquals((long)firstIndexOfSecondCycle, (long)excerptTailer2.index());
            this.readText(excerptTailer2, 5, "test2");
        }
    }

    @Test
    public void firstAndLastIndicesAreRefreshedAfterForceDirectoryListingRefreshInterval() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        SetTimeProvider timeProvider = new SetTimeProvider();
        QueueStoreFileListener listener = new QueueStoreFileListener();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((Path)this.tempQueueDir.resolve("unitTestQueue")).timeProvider((TimeProvider)timeProvider).storeFileListener((StoreFileListener)listener).forceDirectoryListingRefreshIntervalMs(200L).build();){
            ExcerptAppender appender = queue.acquireAppender();
            Assert.assertEquals((long)Long.MAX_VALUE, (long)queue.firstIndex());
            this.writeTextAndReturnFirstIndex(appender, 10, "test");
            timeProvider.advanceMillis(TimeUnit.DAYS.toMillis(1L));
            this.writeTextAndReturnFirstIndex(appender, 5, "test2");
            BackgroundResourceReleaser.releasePendingResources();
            String firstFile = this.getOnlyItem(listener.getReleasedFiles());
            String secondFile = this.getOnlyItem(listener.getAcquiredButNotReleasedFiles());
            Assert.assertNotEquals((Object)firstFile, (Object)secondFile);
            ExcerptTailer tailer = queue.createTailer();
            Files.delete(Paths.get(firstFile, new String[0]));
            Files.delete(Paths.get(secondFile, new String[0]));
            try {
                tailer.toEnd();
                Assert.fail((String)("tailer.toEnd() used to fail when files were deleted under it: " + tailer.index()));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Jvm.pause((long)250L);
            Assert.assertEquals((long)0L, (long)tailer.toEnd().index());
            Assert.assertEquals((long)0L, (long)tailer.toStart().index());
        }
    }

    private long writeTextAndReturnFirstIndex(ExcerptAppender appender, int times, String text) {
        long firstIndex = -1L;
        for (int i = 0; i < times; ++i) {
            appender.writeText((CharSequence)text);
            if (firstIndex >= 0L) continue;
            firstIndex = appender.lastIndexAppended();
        }
        return firstIndex;
    }

    private void readText(ExcerptTailer tailer, int times, String text) {
        for (int i = 0; i < times; ++i) {
            Assert.assertEquals((Object)text, (Object)tailer.readText());
        }
    }

    private <T> T getOnlyItem(Set<T> files) {
        if (files.size() != 1) {
            throw new AssertionError((Object)("Expected a single entry, got: " + files));
        }
        return (T)files.stream().findFirst().orElseThrow(() -> new AssertionError((Object)"This should never happen"));
    }

    static final class QueueStoreFileListener
    implements StoreFileListener {
        private final Set<String> releasedFiles = new HashSet<String>();
        private final Set<String> acquiredButNotReleasedFiles = new HashSet<String>();

        QueueStoreFileListener() {
        }

        public void onReleased(int cycle, File file) {
            System.out.println("onReleased called cycle: " + cycle + ", file: " + file);
            this.releasedFiles.add(file.getAbsolutePath());
            this.acquiredButNotReleasedFiles.remove(file.getAbsolutePath());
        }

        public void onAcquired(int cycle, File file) {
            System.out.println("onAcquired called cycle: " + cycle + ", file: " + file);
            this.acquiredButNotReleasedFiles.add(file.getAbsolutePath());
        }

        public Set<String> getAcquiredButNotReleasedFiles() {
            return this.acquiredButNotReleasedFiles;
        }

        public Set<String> getReleasedFiles() {
            return this.releasedFiles;
        }
    }
}

