/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.IOException;
import java.io.Reader;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.ByteStringParser;

public class ByteStringReader
extends Reader {
    private final ByteStringParser in;

    public ByteStringReader(ByteStringParser in) {
        this.in = in;
    }

    @Override
    public int read() {
        try {
            return this.in.readRemaining() > 0L ? this.in.readUnsignedByte() : -1;
        }
        catch (IllegalStateException e) {
            return -1;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long len = Math.min(this.in.readRemaining(), n);
        try {
            this.in.readSkip(len);
        }
        catch (IllegalStateException | BufferUnderflowException e) {
            throw new IOException(e);
        }
        return len;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        try {
            return this.in.read(cbuf, off, len);
        }
        catch (IllegalStateException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() {
    }
}

