/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.Reader;
import java.math.BigDecimal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.ByteStringReader;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ByteStringParser<B extends ByteStringParser<B>>
extends StreamingDataInput<B> {
    @NotNull
    default public Reader reader() {
        return new ByteStringReader(this);
    }

    @Nullable
    default public Boolean parseBoolean(@NotNull StopCharTester tester) throws BufferUnderflowException, IllegalStateException, ArithmeticException {
        return BytesInternal.parseBoolean(this, tester);
    }

    @Nullable
    default public Boolean parseBoolean() throws BufferUnderflowException, IllegalStateException, ArithmeticException {
        return BytesInternal.parseBoolean(this, StopCharTesters.NON_ALPHA_DIGIT);
    }

    @NotNull
    default public String parseUtf8(@NotNull StopCharTester stopCharTester) throws IllegalStateException, ArithmeticException {
        return BytesInternal.parseUtf8(this, stopCharTester);
    }

    @Deprecated
    @NotNull
    default public String parseUTF(@NotNull StopCharTester stopCharTester) throws IllegalStateException, ArithmeticException {
        return this.parseUtf8(stopCharTester);
    }

    default public void parseUtf8(@NotNull Appendable buffer, @NotNull StopCharTester stopCharTester) throws BufferUnderflowException, IllegalStateException, ArithmeticException {
        BytesInternal.parseUtf8((StreamingDataInput)this, buffer, stopCharTester);
    }

    @Deprecated
    default public void parseUTF(@NotNull Appendable buffer, @NotNull StopCharTester stopCharTester) throws BufferUnderflowException, IllegalStateException, ArithmeticException {
        this.parseUtf8(buffer, stopCharTester);
    }

    default public void parseUtf8(@NotNull Appendable buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, IORuntimeException, IllegalStateException {
        BytesInternal.parseUtf8((StreamingDataInput)this, buffer, stopCharsTester);
    }

    @Deprecated
    default public void parseUTF(@NotNull Appendable buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, IORuntimeException, IllegalStateException {
        this.parseUtf8(buffer, stopCharsTester);
    }

    default public void parse8bit(Appendable buffer, @NotNull StopCharTester stopCharTester) throws BufferUnderflowException, BufferOverflowException, IllegalStateException, ArithmeticException {
        if (buffer instanceof StringBuilder) {
            BytesInternal.parse8bit((StreamingDataInput)this, (StringBuilder)buffer, stopCharTester);
        } else {
            BytesInternal.parse8bit((StreamingDataInput)this, (Bytes)buffer, stopCharTester);
        }
    }

    default public String parse8bit(@NotNull StopCharTester stopCharTester) throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.parse8bit(this, stopCharTester);
    }

    default public void parse8bit(Appendable buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, BufferOverflowException, IllegalStateException, ArithmeticException {
        if (buffer instanceof StringBuilder) {
            BytesInternal.parse8bit((StreamingDataInput)this, (StringBuilder)buffer, stopCharsTester);
        } else {
            BytesInternal.parse8bit((StreamingDataInput)this, (Bytes)buffer, stopCharsTester);
        }
    }

    default public void parse8bit(Bytes buffer, @NotNull StopCharsTester stopCharsTester) throws BufferUnderflowException, BufferOverflowException, IllegalStateException, ArithmeticException {
        BytesInternal.parse8bit((StreamingDataInput)this, buffer, stopCharsTester);
    }

    default public void parse8bit(StringBuilder buffer, @NotNull StopCharsTester stopCharsTester) throws IllegalStateException {
        BytesInternal.parse8bit((StreamingDataInput)this, buffer, stopCharsTester);
    }

    default public int parseInt() throws BufferUnderflowException, ArithmeticException, IllegalStateException {
        return Maths.toInt32(BytesInternal.parseLong(this));
    }

    default public long parseLong() throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.parseLong(this);
    }

    default public float parseFloat() throws BufferUnderflowException, IllegalStateException {
        return (float)BytesInternal.parseDouble(this);
    }

    default public double parseDouble() throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.parseDouble(this);
    }

    default public long parseLongDecimal() throws BufferUnderflowException, IllegalStateException {
        return BytesInternal.parseLongDecimal(this);
    }

    public int lastDecimalPlaces();

    public void lastDecimalPlaces(int var1);

    public boolean lastNumberHadDigits();

    public void lastNumberHadDigits(boolean var1);

    default public boolean skipTo(@NotNull StopCharTester tester) throws IllegalStateException {
        return BytesInternal.skipTo(this, tester);
    }

    @NotNull
    default public BigDecimal parseBigDecimal() throws IllegalStateException, ArithmeticException {
        return new BigDecimal(this.parseUtf8(StopCharTesters.NUMBER_END));
    }
}

