/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.TailerState;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public final class TailerIndexingQueueTest
extends ChronicleQueueTestBase {
    private final File path = this.getTmpDir();
    private final AtomicLong clock = new AtomicLong(System.currentTimeMillis());

    private static void deleteFile(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new AssertionError("Could not delete", e);
        }
    }

    private static ChronicleQueue createQueue(File path, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.binary((File)path).timeProvider(timeProvider).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).testBlockSize().wireType(WireType.BINARY).build();
    }

    @Test
    public void tailerShouldBeAbleToMoveBackwardFromEndOfCycle() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (ChronicleQueue queue = TailerIndexingQueueTest.createQueue(this.path, this.clock::get);){
            ExcerptAppender appender = queue.acquireAppender();
            IntStream.range(0, 5).forEach(i -> {
                try (DocumentContext ctx = appender.writingDocument();){
                    ctx.wire().write().int32(i);
                    this.clock.addAndGet(TimeUnit.SECONDS.toMillis(10L));
                }
            });
        }
        var2_2 = null;
        try (Stream<Path> list = Files.list(this.path.toPath());
             Stream<Path> list2 = Files.list(this.path.toPath());){
            Path firstFile = list.sorted(Comparator.comparing(Path::toString)).findFirst().orElseThrow(AssertionError::new);
            list2.filter(p -> !p.equals(firstFile)).forEach(TailerIndexingQueueTest::deleteFile);
            try (ChronicleQueue queue = TailerIndexingQueueTest.createQueue(this.path, (TimeProvider)SystemTimeProvider.INSTANCE);){
                ExcerptTailer tailer = queue.createTailer().toEnd();
                try (DocumentContext readCtx = tailer.readingDocument();){
                    Assert.assertFalse((boolean)readCtx.isPresent());
                }
                Assert.assertEquals((Object)TailerState.END_OF_CYCLE, (Object)tailer.state());
                tailer.direction(TailerDirection.BACKWARD);
                tailer.toEnd();
                Assert.assertTrue((boolean)tailer.readingDocument().isPresent());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }
}

