/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PeekDocumentTest
extends ChronicleQueueTestBase {
    private static final String EXPECTED_MESSAGE = "hello world";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWrite10() {
        File tempDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
            Throwable throwable;
            ExcerptAppender appender = queue.acquireAppender();
            for (int i = 0; i < 1024; ++i) {
                throwable = null;
                try (DocumentContext documentContext = appender.writingDocument();){
                    documentContext.wire().write((CharSequence)"value").text("hello" + i);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            ExcerptTailer tailer = queue.createTailer();
            for (int i = 0; i < 1024; ++i) {
                Assert.assertTrue((boolean)tailer.peekDocument());
                try (DocumentContext documentContext = tailer.readingDocument();){
                    Assert.assertTrue((boolean)documentContext.isPresent());
                    Assert.assertTrue((boolean)tailer.peekDocument());
                    Wire wire = documentContext.wire();
                    long l = wire.bytes().readPosition();
                    try {
                        Assert.assertEquals((Object)("hello" + i), (Object)wire.read("value").text());
                        continue;
                    }
                    finally {
                        if (l % 2L == 0L) {
                            wire.bytes().readPosition(l);
                        }
                    }
                }
            }
            Assert.assertFalse((boolean)tailer.peekDocument());
            throwable = null;
            try (DocumentContext documentContext = appender.writingDocument();){
                documentContext.wire().write((CharSequence)"value").text("hello10");
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            Assert.assertTrue((boolean)tailer.peekDocument());
        }
        finally {
            tempDir.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWrite10Backwards() {
        File tempDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext documentContext = appender.writingDocument();){
                documentContext.wire().write((CharSequence)"value").text("hello");
            }
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertTrue((boolean)tailer.peekDocument());
            try (DocumentContext documentContext = tailer.readingDocument();){
                Assert.assertTrue((boolean)documentContext.isPresent());
                Assert.assertTrue((boolean)tailer.peekDocument());
                Wire wire = documentContext.wire();
                String result = wire.read("value").text();
                Assert.assertEquals((Object)"hello", (Object)result);
            }
            Assert.assertFalse((boolean)tailer.peekDocument());
            tailer.direction(TailerDirection.BACKWARD);
            Assert.assertTrue((boolean)tailer.peekDocument());
            documentContext = tailer.readingDocument();
            var7_11 = null;
            if (documentContext != null) {
                if (var7_11 != null) {
                    try {
                        documentContext.close();
                    }
                    catch (Throwable throwable) {
                        var7_11.addSuppressed(throwable);
                    }
                } else {
                    documentContext.close();
                }
            }
            Assert.assertFalse((boolean)tailer.peekDocument());
        }
        finally {
            tempDir.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWrite() {
        File tempDir = this.getTmpDir();
        try {
            Bytes bytes = Bytes.from((String)EXPECTED_MESSAGE);
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
                ExcerptAppender appender = queue.acquireAppender();
                appender.writeText((CharSequence)"hello");
                ExcerptTailer tailer = queue.createTailer();
                Assert.assertTrue((boolean)tailer.peekDocument());
            }
        }
        finally {
            tempDir.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2() {
        File tempDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)tempDir).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"hello1");
            appender.writeText((CharSequence)"hello2");
            ExcerptTailer tailer = queue.createTailer();
            long address1a = (Long)Jvm.getValue((Object)tailer, (String)"address");
            Assert.assertTrue((boolean)tailer.moveToIndex(tailer.index() + 1L));
            long address1b = (Long)Jvm.getValue((Object)tailer, (String)"address");
            Assert.assertNotEquals((long)address1a, (long)address1b);
            Assert.assertFalse((boolean)tailer.moveToIndex(tailer.index() + 1L));
            long address1c = (Long)Jvm.getValue((Object)tailer, (String)"address");
            Assert.assertEquals((long)address1c, (long)NoBytesStore.NO_PAGE);
        }
        finally {
            tempDir.deleteOnExit();
        }
    }

    @Test
    public void testWhenNoDocument() {
        File tempDir = this.getTmpDir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)tempDir).build();){
            ExcerptTailer tailer = queue.createTailer();
            ExcerptAppender appender = queue.acquireAppender();
            boolean peekDocumentBeforeWrite = tailer.peekDocument();
            Assert.assertFalse((boolean)peekDocumentBeforeWrite);
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().writeText((CharSequence)"testString");
            }
            boolean peekDocumentAfterWrite = tailer.peekDocument();
            Assert.assertTrue((boolean)peekDocumentAfterWrite);
            String text = null;
            try (DocumentContext dc = tailer.readingDocument();){
                text = dc.wire().readText();
            }
            Assert.assertEquals((Object)"testString", (Object)text);
            boolean peekDocumentAfterRead = tailer.peekDocument();
            Assert.assertFalse((boolean)peekDocumentAfterRead);
        }
    }

    @Ignore(value="PeekDocument gets stuck and reports no messages when there are messages - https://github.com/OpenHFT/Chronicle-Queue/issues/797")
    @Test
    public void soakTestPeekDocument() throws ExecutionException, InterruptedException {
        File tempDir = this.getTmpDir();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.single((File)tempDir).rollCycle((RollCycle)RollCycles.MINUTELY).build();){
            long maxMessagesPerCycle = RollCycles.MINUTELY.maxMessagesPerCycle();
            System.out.println("maxMessagesPerCycle = " + DecimalFormat.getInstance().format(maxMessagesPerCycle));
            ScheduledExecutorService es2 = Executors.newSingleThreadScheduledExecutor();
            es2.submit(() -> {
                try (ExcerptAppender appender = q.acquireAppender();){
                    int i = 0;
                    while ((long)i < maxMessagesPerCycle) {
                        try (DocumentContext documentContext = appender.writingDocument();){
                            documentContext.wire().write((CharSequence)"value").int64((long)i);
                        }
                        ++i;
                    }
                }
            });
            ScheduledExecutorService es = Executors.newSingleThreadScheduledExecutor();
            es.submit(() -> PeekDocumentTest.lambda$soakTestPeekDocument$1(q, maxMessagesPerCycle)).get();
            es.shutdownNow();
            es2.shutdownNow();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object lambda$soakTestPeekDocument$1(SingleChronicleQueue q, long maxMessagesPerCycle) throws Exception {
        excerptTailer = q.createTailer();
        var4_3 = null;
        try {
            count = 0L;
            Thread.yield();
            while (true) {
                if (!excerptTailer.peekDocument()) {
                    continue;
                }
                dc = excerptTailer.readingDocument();
                var8_7 = null;
                if (dc.isPresent()) ** GOTO lbl-1000
                if (dc == null) continue;
                if (var8_7 != null) {
                }
                ** GOTO lbl38
                {
                    block32: {
                        block33: {
                            catch (Throwable var9_11) {
                                try {
                                    var8_7 = var9_11;
                                    throw var9_11;
                                }
                                catch (Throwable var11_14) {
                                    if (dc == null) throw var11_14;
                                    if (var8_7 == null) {
                                        dc.close();
                                        throw var11_14;
                                    }
                                    try {
                                        dc.close();
                                        throw var11_14;
                                    }
                                    catch (Throwable var12_15) {
                                        var8_7.addSuppressed(var12_15);
                                        throw var11_14;
                                    }
                                }
                            }
                            try {
                                dc.close();
                            }
                            catch (Throwable var9_9) {
                                var8_7.addSuppressed(var9_9);
                            }
                            continue;
lbl38:
                            // 1 sources

                            dc.close();
                            continue;
lbl-1000:
                            // 1 sources

                            {
                                Assert.assertEquals((long)count, (long)dc.wire().read("value").int64());
                                if (++count % 1000000L == 0L) {
                                    System.out.println("count = " + DecimalFormat.getInstance().format(count));
                                }
                                if (count != maxMessagesPerCycle) break block32;
                                var9_8 = null;
                                if (dc == null) return var9_8;
                                if (var8_7 == null) break block33;
                            }
                            try {
                                dc.close();
                                return var9_8;
                            }
                            catch (Throwable var10_12) {
                                var8_7.addSuppressed(var10_12);
                                return var9_8;
                            }
                        }
                        dc.close();
                        return var9_8;
                    }
                    ** try [egrp 7[TRYBLOCK] [11 : 247->345)] { 
lbl58:
                    // 1 sources

                    if (dc == null) continue;
                    if (var8_7 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable var9_10) {
                            var8_7.addSuppressed(var9_10);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
        }
lbl68:
        // 2 sources

        catch (Throwable var5_5) {
            var4_3 = var5_5;
            throw var5_5;
        }
        finally {
            if (excerptTailer != null) {
                if (var4_3 != null) {
                    try {
                        excerptTailer.close();
                    }
                    catch (Throwable var10_13) {
                        var4_3.addSuppressed(var10_13);
                    }
                } else {
                    excerptTailer.close();
                }
            }
        }
    }
}

