/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.util.function.ToIntFunction;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.DirectoryListing;
import org.jetbrains.annotations.NotNull;

final class TableDirectoryListing
extends AbstractCloseable
implements DirectoryListing {
    private static final String HIGHEST_CREATED_CYCLE = "listing.highestCycle";
    private static final String LOWEST_CREATED_CYCLE = "listing.lowestCycle";
    private static final String MOD_COUNT = "listing.modCount";
    static final int UNSET_MAX_CYCLE = Integer.MIN_VALUE;
    static final int UNSET_MIN_CYCLE = Integer.MAX_VALUE;
    static final String INITIAL_MIN_FILENAME = Character.toString('\uffff');
    static final String INITIAL_MAX_FILENAME = Character.toString('\u0000');
    private final TableStore<?> tableStore;
    private final Path queuePath;
    private final ToIntFunction<String> fileNameToCycleFunction;
    private volatile LongValue maxCycleValue;
    private volatile LongValue minCycleValue;
    private volatile LongValue modCount;
    private long lastRefreshTimeMS = 0L;

    TableDirectoryListing(@NotNull TableStore<?> tableStore, Path queuePath, ToIntFunction<String> fileNameToCycleFunction) {
        this.tableStore = tableStore;
        this.queuePath = queuePath;
        this.fileNameToCycleFunction = fileNameToCycleFunction;
        if (tableStore.readOnly()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " should only be used for writable queues");
        }
    }

    @Override
    public void init() {
        this.throwExceptionIfClosedInSetter();
        this.tableStore.doWithExclusiveLock(ts -> {
            this.maxCycleValue = ts.acquireValueFor(HIGHEST_CREATED_CYCLE);
            this.minCycleValue = ts.acquireValueFor(LOWEST_CREATED_CYCLE);
            this.minCycleValue.compareAndSwapValue(Long.MIN_VALUE, Integer.MAX_VALUE);
            this.modCount = ts.acquireValueFor(MOD_COUNT);
            if (this.modCount.getVolatileValue() == Long.MIN_VALUE) {
                this.modCount.compareAndSwapValue(Long.MIN_VALUE, 0L);
            }
            return this;
        });
    }

    @Override
    public void refresh(boolean force) {
        if (!force) {
            return;
        }
        this.lastRefreshTimeMS = System.currentTimeMillis();
        long currentMin0 = this.minCycleValue.getVolatileValue();
        long currentMax0 = this.maxCycleValue.getVolatileValue();
        while (true) {
            this.throwExceptionIfClosed();
            this.tableStore.throwExceptionIfClosed();
            Jvm.safepoint();
            long currentMax = this.maxCycleValue.getVolatileValue();
            String[] fileNamesList = this.queuePath.toFile().list();
            String minFilename = INITIAL_MIN_FILENAME;
            String maxFilename = INITIAL_MAX_FILENAME;
            if (fileNamesList != null) {
                for (String fileName : fileNamesList) {
                    if (!fileName.endsWith(".cq4")) continue;
                    if (minFilename.compareTo(fileName) > 0) {
                        minFilename = fileName;
                    }
                    if (maxFilename.compareTo(fileName) >= 0) continue;
                    maxFilename = fileName;
                }
            }
            int min = Integer.MAX_VALUE;
            if (!INITIAL_MIN_FILENAME.equals(minFilename)) {
                min = this.fileNameToCycleFunction.applyAsInt(minFilename);
            }
            int max = Integer.MIN_VALUE;
            if (!INITIAL_MAX_FILENAME.equals(maxFilename)) {
                max = this.fileNameToCycleFunction.applyAsInt(maxFilename);
            }
            if (currentMin0 == (long)min && currentMax0 == (long)max) {
                return;
            }
            this.minCycleValue.setOrderedValue((long)min);
            if (this.maxCycleValue.compareAndSwapValue(currentMax, (long)max)) break;
            Jvm.nanoPause();
        }
        this.modCount.addAtomicValue(1L);
    }

    @Override
    public void onFileCreated(File file, int cycle) {
        this.onRoll(cycle);
    }

    @Override
    public void onRoll(int cycle) {
        this.minCycleValue.setMinValue((long)cycle);
        this.maxCycleValue.setMaxValue((long)cycle);
        this.modCount.addAtomicValue(1L);
    }

    @Override
    public long lastRefreshTimeMS() {
        return this.lastRefreshTimeMS;
    }

    @Override
    public int getMaxCreatedCycle() {
        return this.getMaxCycleValue();
    }

    @Override
    public int getMinCreatedCycle() {
        return this.getMinCycleValue();
    }

    @Override
    public long modCount() {
        return this.modCount.getVolatileValue();
    }

    public String toString() {
        return this.tableStore.dump();
    }

    protected void performClose() {
        Closeable.closeQuietly((Object[])new Object[]{this.minCycleValue, this.maxCycleValue, this.modCount});
    }

    private int getMaxCycleValue() {
        return (int)this.maxCycleValue.getVolatileValue();
    }

    private int getMinCycleValue() {
        return (int)this.minCycleValue.getVolatileValue();
    }

    protected boolean threadSafetyCheck(boolean isUsed) {
        return true;
    }
}

