/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.jetbrains.annotations.NotNull;

public class LongRunTestMain {
    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        TLogEntry entry = new TLogEntry();
        entry.setSessionId(321234L);
        entry.setLogLevel(77);
        entry.setSecurityLevel(1234);
        entry.setPosixTimestamp(6141234321L);
        entry.setMessage("This is a test message for the system................................ A");
        LogEntryOutput output = new LogEntryOutput(1024);
        output.setMarshallable(entry);
        SingleChronicleQueue queue = ChronicleQueue.singleBuilder((String)(OS.getTarget() + "/test-" + System.nanoTime())).rollCycle((RollCycle)RollCycles.HOURLY).build();
        ExcerptAppender appender = queue.acquireAppender();
        Jvm.setExceptionHandlers((ExceptionHandler)Slf4jExceptionHandler.FATAL, (ExceptionHandler)Slf4jExceptionHandler.WARN, (ExceptionHandler)Slf4jExceptionHandler.WARN);
        for (int j = 0; j < 100; ++j) {
            for (int i = 0; i < 100000; ++i) {
                appender.writeBytes((WriteBytesMarshallable)output);
            }
            System.out.println((j + 1) * 100000);
        }
        queue.close();
        System.out.println("took " + (double)(System.currentTimeMillis() - start) / 1000.0);
    }

    static class LogEntryOutput
    implements WriteBytesMarshallable {
        private final int maxMessageSize;
        private TLogEntry logEntry;

        LogEntryOutput(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
        }

        public void setMarshallable(TLogEntry logEntry) {
            this.logEntry = logEntry;
        }

        public void writeMarshallable(@NotNull BytesOut bytes) {
            bytes.writeLong(this.logEntry.getSessionId());
            bytes.writeInt(this.logEntry.getLogLevel());
            bytes.writeInt(this.logEntry.getSecurityLevel());
            bytes.writeLong(this.logEntry.getPosixTimestamp());
            int messageSize = Math.min(this.logEntry.getMessage().length(), this.maxMessageSize);
            bytes.writeStopBit((long)messageSize);
            bytes.write(this.logEntry.getMessage(), 0, messageSize);
        }
    }

    static class TLogEntry {
        private long sessionId;
        private int logLevel;
        private int securityLevel;
        private long posixTimestamp;
        private CharSequence message;

        TLogEntry() {
        }

        public long getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(long sessionId) {
            this.sessionId = sessionId;
        }

        public int getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(int logLevel) {
            this.logLevel = logLevel;
        }

        public int getSecurityLevel() {
            return this.securityLevel;
        }

        public void setSecurityLevel(int securityLevel) {
            this.securityLevel = securityLevel;
        }

        public long getPosixTimestamp() {
            return this.posixTimestamp;
        }

        public void setPosixTimestamp(long posixTimestamp) {
            this.posixTimestamp = posixTimestamp;
        }

        public CharSequence getMessage() {
            return this.message;
        }

        public void setMessage(CharSequence message) {
            this.message = message;
        }
    }
}

